/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.expressions;

import org.eclipse.core.expressions.ElementHandler;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.internal.expressions.CompositeExpression;
import org.eclipse.core.internal.expressions.ExpressionMessages;
import org.eclipse.core.internal.expressions.ExpressionPlugin;
import org.eclipse.core.internal.expressions.Messages;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class ExpressionConverter {
    private ElementHandler[] fHandlers;
    private static final ExpressionConverter INSTANCE = new ExpressionConverter(new ElementHandler[]{ElementHandler.getDefault()});

    public static ExpressionConverter getDefault() {
        return INSTANCE;
    }

    public ExpressionConverter(ElementHandler[] handlers) {
        Assert.isNotNull(handlers);
        this.fHandlers = handlers;
    }

    public Expression perform(IConfigurationElement root) throws CoreException {
        int i = 0;
        while (i < this.fHandlers.length) {
            ElementHandler handler = this.fHandlers[i];
            Expression result = handler.create(this, root);
            if (result != null) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public Expression perform(Element root) throws CoreException {
        int i = 0;
        while (i < this.fHandlers.length) {
            ElementHandler handler = this.fHandlers[i];
            Expression result = handler.create(this, root);
            if (result != null) {
                return result;
            }
            ++i;
        }
        return null;
    }

    void processChildren(IConfigurationElement element, CompositeExpression result) throws CoreException {
        IConfigurationElement[] children = element.getChildren();
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                Expression child = this.perform(children[i]);
                if (child == null) {
                    throw new CoreException(new Status(4, ExpressionPlugin.getPluginId(), 4, Messages.format(ExpressionMessages.Expression_unknown_element, children[i].getName()), null));
                }
                result.add(child);
                ++i;
            }
        }
    }

    void processChildren(Element element, CompositeExpression result) throws CoreException {
        Node child = element.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1) {
                Expression exp = this.perform((Element)child);
                if (exp == null) {
                    throw new CoreException(new Status(4, ExpressionPlugin.getPluginId(), 4, Messages.format(ExpressionMessages.Expression_unknown_element, child.getNodeName()), null));
                }
                result.add(exp);
            }
            child = child.getNextSibling();
        }
    }
}

