/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.validate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.Immutable;
import org.modeshape.graph.query.model.SelectorName;
import org.modeshape.graph.query.validate.ImmutableColumn;
import org.modeshape.graph.query.validate.ImmutableKey;
import org.modeshape.graph.query.validate.Schemata;

@Immutable
class ImmutableTable
implements Schemata.Table {
    private final SelectorName name;
    private final Map<String, Schemata.Column> columnsByName;
    private final List<Schemata.Column> columns;
    private final Set<Schemata.Key> keys;
    private final boolean extraColumns;
    private final List<Schemata.Column> selectStarColumns;
    private final Map<String, Schemata.Column> selectStarColumnsByName;

    protected ImmutableTable(SelectorName name, Iterable<Schemata.Column> columns, boolean extraColumns) {
        this(name, columns, extraColumns, (Iterable[])null);
    }

    protected ImmutableTable(SelectorName name, Iterable<Schemata.Column> columns, boolean extraColumns, Iterable<Schemata.Column> ... keyColumns) {
        this.name = name;
        ArrayList<Schemata.Column> columnList = new ArrayList<Schemata.Column>();
        HashMap<String, Schemata.Column> columnMap = new HashMap<String, Schemata.Column>();
        for (Schemata.Column column : columns) {
            Schemata.Column old = columnMap.put(column.getName(), column);
            if (old != null) {
                columnList.set(columnList.indexOf(old), column);
                continue;
            }
            columnList.add(column);
        }
        this.columnsByName = Collections.unmodifiableMap(columnMap);
        this.columns = Collections.unmodifiableList(columnList);
        if (keyColumns != null) {
            HashSet<ImmutableKey> keys = new HashSet<ImmutableKey>();
            for (Iterable<Schemata.Column> keyColumnSet : keyColumns) {
                if (keyColumnSet == null) continue;
                ImmutableKey key = new ImmutableKey(keyColumnSet);
                keys.add(key);
            }
            this.keys = Collections.unmodifiableSet(keys);
        } else {
            this.keys = Collections.emptySet();
        }
        this.extraColumns = extraColumns;
        this.selectStarColumns = this.columns;
        this.selectStarColumnsByName = this.columnsByName;
    }

    protected ImmutableTable(SelectorName name, Map<String, Schemata.Column> columnsByName, List<Schemata.Column> columns, Set<Schemata.Key> keys, boolean extraColumns, Map<String, Schemata.Column> selectStarColumnsByName, List<Schemata.Column> selectStarColumns) {
        this.name = name;
        this.columns = columns;
        this.columnsByName = columnsByName;
        this.keys = keys;
        this.extraColumns = extraColumns;
        assert (selectStarColumns != null);
        assert (selectStarColumnsByName != null);
        assert (selectStarColumns.size() == selectStarColumnsByName.size());
        this.selectStarColumns = selectStarColumns;
        this.selectStarColumnsByName = selectStarColumnsByName;
    }

    @Override
    public SelectorName getName() {
        return this.name;
    }

    @Override
    public Schemata.Column getColumn(String name) {
        return this.columnsByName.get(name);
    }

    @Override
    public List<Schemata.Column> getColumns() {
        return this.columns;
    }

    @Override
    public List<Schemata.Column> getSelectAllColumns() {
        return this.selectStarColumns;
    }

    @Override
    public Map<String, Schemata.Column> getSelectAllColumnsByName() {
        return this.selectStarColumnsByName;
    }

    @Override
    public Map<String, Schemata.Column> getColumnsByName() {
        return this.columnsByName;
    }

    @Override
    public Collection<Schemata.Key> getKeys() {
        return this.keys;
    }

    protected Set<Schemata.Key> getKeySet() {
        return this.keys;
    }

    @Override
    public Schemata.Key getKey(Schemata.Column ... columns) {
        for (Schemata.Key key : this.keys) {
            if (!key.hasColumns(columns)) continue;
            return key;
        }
        return null;
    }

    @Override
    public Schemata.Key getKey(Iterable<Schemata.Column> columns) {
        for (Schemata.Key key : this.keys) {
            if (!key.hasColumns(columns)) continue;
            return key;
        }
        return null;
    }

    @Override
    public boolean hasKey(Schemata.Column ... columns) {
        return this.getKey(columns) != null;
    }

    @Override
    public boolean hasKey(Iterable<Schemata.Column> columns) {
        return this.getKey(columns) != null;
    }

    @Override
    public boolean hasExtraColumns() {
        return this.extraColumns;
    }

    public ImmutableTable withColumn(String name, String type) {
        return this.withColumn(name, type, false);
    }

    public ImmutableTable withColumn(String name, String type, boolean fullTextSearchable) {
        ImmutableColumn newColumn = new ImmutableColumn(name, type, fullTextSearchable);
        LinkedList<Schemata.Column> newColumns = new LinkedList<Schemata.Column>(this.columns);
        newColumns.add(newColumn);
        LinkedList<Schemata.Column> selectStarColumns = new LinkedList<Schemata.Column>(this.selectStarColumns);
        HashMap<String, Schemata.Column> selectStarColumnMap = new HashMap<String, Schemata.Column>(this.selectStarColumnsByName);
        HashMap<String, Schemata.Column> columnMap = new HashMap<String, Schemata.Column>(this.columnsByName);
        Schemata.Column existing = columnMap.put(newColumn.getName(), newColumn);
        if (existing != null) {
            newColumns.remove(existing);
            if (selectStarColumnMap.containsKey(existing.getName())) {
                selectStarColumnMap.put(newColumn.getName(), newColumn);
                selectStarColumns.add(newColumn);
            }
        }
        return new ImmutableTable(this.getName(), columnMap, newColumns, this.keys, this.extraColumns, selectStarColumnMap, selectStarColumns);
    }

    public ImmutableTable withColumns(Iterable<Schemata.Column> columns) {
        LinkedList<Schemata.Column> newColumns = new LinkedList<Schemata.Column>(this.getColumns());
        LinkedList<Schemata.Column> selectStarColumns = new LinkedList<Schemata.Column>(this.selectStarColumns);
        HashMap<String, Schemata.Column> selectStarColumnMap = new HashMap<String, Schemata.Column>(this.selectStarColumnsByName);
        HashMap<String, Schemata.Column> columnMap = new HashMap<String, Schemata.Column>(this.columnsByName);
        for (Schemata.Column column : columns) {
            ImmutableColumn newColumn = new ImmutableColumn(column.getName(), column.getPropertyType(), column.isFullTextSearchable());
            newColumns.add(newColumn);
            Schemata.Column existing = columnMap.put(newColumn.getName(), newColumn);
            if (existing == null) continue;
            newColumns.remove(existing);
            if (!selectStarColumnMap.containsKey(existing.getName())) continue;
            selectStarColumnMap.put(newColumn.getName(), newColumn);
            selectStarColumns.add(newColumn);
        }
        return new ImmutableTable(this.getName(), columnMap, newColumns, this.keys, this.extraColumns, selectStarColumnMap, selectStarColumns);
    }

    public ImmutableTable with(SelectorName name) {
        return new ImmutableTable(name, this.columnsByName, this.columns, this.keys, this.extraColumns, this.selectStarColumnsByName, this.selectStarColumns);
    }

    public ImmutableTable withKey(Iterable<Schemata.Column> keyColumns) {
        HashSet<Schemata.Key> keys = new HashSet<Schemata.Key>(this.keys);
        for (Schemata.Column keyColumn : keyColumns) {
            assert (this.columns.contains(keyColumn));
        }
        if (!keys.add(new ImmutableKey(keyColumns))) {
            return this;
        }
        return new ImmutableTable(this.name, this.columnsByName, this.columns, keys, this.extraColumns, this.selectStarColumnsByName, this.selectStarColumns);
    }

    public ImmutableTable withKey(Schemata.Column ... keyColumns) {
        return this.withKey(Arrays.asList(keyColumns));
    }

    public ImmutableTable withExtraColumns() {
        return this.extraColumns ? this : new ImmutableTable(this.name, this.columnsByName, this.columns, this.keys, true, this.selectStarColumnsByName, this.selectStarColumns);
    }

    public ImmutableTable withoutExtraColumns() {
        return !this.extraColumns ? this : new ImmutableTable(this.name, this.columnsByName, this.columns, this.keys, false, this.selectStarColumnsByName, this.selectStarColumns);
    }

    public ImmutableTable withColumnNotInSelectStar(String name) {
        Schemata.Column column = this.columnsByName.get(name);
        if (column == null) {
            return this;
        }
        if (!this.getSelectAllColumnsByName().containsKey(name)) {
            return this;
        }
        LinkedList<Schemata.Column> selectStarColumns = new LinkedList<Schemata.Column>(this.selectStarColumns);
        HashMap<String, Schemata.Column> selectStarColumnsByName = new HashMap<String, Schemata.Column>(this.selectStarColumnsByName);
        selectStarColumns.remove(column);
        selectStarColumnsByName.remove(name);
        return new ImmutableTable(this.name, this.columnsByName, this.columns, this.keys, this.extraColumns, selectStarColumnsByName, selectStarColumns);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.name.name());
        sb.append('(');
        boolean first = true;
        for (Schemata.Column column : this.columns) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(column);
        }
        sb.append(')');
        if (!this.keys.isEmpty()) {
            sb.append(" with keys ");
            first = true;
            for (Schemata.Key key : this.keys) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(key);
            }
        }
        return sb.toString();
    }
}

