/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.request;

import java.util.Collections;
import java.util.Set;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.HashCode;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.Location;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.request.ChangeRequest;
import org.modeshape.graph.request.RequestType;

public class CloneBranchRequest
extends ChangeRequest {
    private static final long serialVersionUID = 1L;
    private final String fromWorkspace;
    private final String intoWorkspace;
    private final Location from;
    private final Location into;
    private final Name desiredName;
    private final Path.Segment desiredSegment;
    private final boolean removeExisting;
    private Set<Location> removedExistingNodes;
    private Location actualFromLocation;
    private Location actualIntoLocation;

    public CloneBranchRequest(Location from, String fromWorkspace, Location into, String intoWorkspace, Name nameForClone, Path.Segment exactSegmentForClone, boolean removeExisting) {
        CheckArg.isNotNull(from, "from");
        CheckArg.isNotNull(into, "into");
        CheckArg.isNotNull(fromWorkspace, "fromWorkspace");
        CheckArg.isNotNull(intoWorkspace, "intoWorkspace");
        CheckArg.isNotSame(from, fromWorkspace, into, intoWorkspace);
        assert (nameForClone != null ? exactSegmentForClone == null : exactSegmentForClone != null);
        this.from = from;
        this.into = into;
        this.fromWorkspace = fromWorkspace;
        this.intoWorkspace = intoWorkspace;
        this.desiredName = nameForClone;
        this.desiredSegment = exactSegmentForClone;
        this.removeExisting = removeExisting;
    }

    public Location from() {
        return this.from;
    }

    public Location into() {
        return this.into;
    }

    public String fromWorkspace() {
        return this.fromWorkspace;
    }

    public String intoWorkspace() {
        return this.intoWorkspace;
    }

    public boolean isSameWorkspace() {
        return false;
    }

    public Name desiredName() {
        return this.desiredName;
    }

    public Path.Segment desiredSegment() {
        return this.desiredSegment;
    }

    public boolean removeExisting() {
        return this.removeExisting;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    public void setActualLocations(Location fromLocation, Location intoLocation) {
        this.checkNotFrozen();
        CheckArg.isNotNull(fromLocation, "intoLocation");
        CheckArg.isNotNull(intoLocation, "intoLocation");
        if (!fromLocation.hasPath()) {
            throw new IllegalArgumentException(GraphI18n.actualOldLocationMustHavePath.text(fromLocation));
        }
        if (!intoLocation.hasPath()) {
            throw new IllegalArgumentException(GraphI18n.actualNewLocationMustHavePath.text(intoLocation));
        }
        if (this.desiredSegment != null && !this.desiredSegment.equals(intoLocation.getPath().getLastSegment())) {
            throw new IllegalArgumentException(GraphI18n.actualLocationIsNotAtCorrectChildSegment.text(intoLocation, this.desiredSegment));
        }
        if (this.desiredName != null && !this.desiredName.equals(intoLocation.getPath().getLastSegment().getName())) {
            throw new IllegalArgumentException(GraphI18n.actualLocationDoesNotHaveCorrectChildName.text(intoLocation, this.desiredName));
        }
        this.actualFromLocation = fromLocation;
        this.actualIntoLocation = intoLocation;
    }

    public Location getActualLocationBefore() {
        return this.actualFromLocation;
    }

    public Location getActualLocationAfter() {
        return this.actualIntoLocation;
    }

    public void setRemovedNodes(Set<Location> existingNodesThatWereRemoved) {
        this.removedExistingNodes = existingNodesThatWereRemoved;
    }

    public Set<Location> getRemovedNodes() {
        return this.removedExistingNodes != null ? this.removedExistingNodes : Collections.emptySet();
    }

    @Override
    public boolean changes(String workspace, Path path) {
        return this.into.hasPath() && this.into.getPath().isAtOrBelow(path);
    }

    @Override
    public Location changedLocation() {
        return this.actualIntoLocation != null ? this.actualIntoLocation : this.into;
    }

    @Override
    public String changedWorkspace() {
        return this.intoWorkspace();
    }

    public int hashCode() {
        return HashCode.compute(this.from, this.fromWorkspace, this.into, this.intoWorkspace);
    }

    @Override
    public void cancel() {
        super.cancel();
        this.actualFromLocation = null;
        this.actualIntoLocation = null;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (this.getClass().isInstance(obj)) {
            CloneBranchRequest that = (CloneBranchRequest)obj;
            if (!this.from().isSame(that.from())) {
                return false;
            }
            if (!this.into().isSame(that.into())) {
                return false;
            }
            if (!this.fromWorkspace.equals(that.fromWorkspace)) {
                return false;
            }
            return this.intoWorkspace.equals(that.intoWorkspace);
        }
        return false;
    }

    public String toString() {
        if (this.desiredName != null) {
            return "clone branch " + this.from() + " in the \"" + this.fromWorkspace + "\" workspace into " + this.into() + " with name " + this.desiredName + " in the \"" + this.intoWorkspace + "\" workspace";
        }
        return "clone branch " + this.from() + " in the \"" + this.fromWorkspace + "\" workspace into " + this.into() + " in the \"" + this.intoWorkspace + "\" workspace as child " + this.desiredSegment();
    }

    @Override
    public CloneBranchRequest clone() {
        CloneBranchRequest result = new CloneBranchRequest(this.actualFromLocation != null ? this.actualFromLocation : this.from, this.fromWorkspace, this.actualIntoLocation != null ? this.actualIntoLocation : this.into, this.intoWorkspace, this.desiredName, this.desiredSegment, this.removeExisting);
        result.setRemovedNodes(this.removedExistingNodes);
        result.setActualLocations(this.actualFromLocation, this.actualIntoLocation);
        return result;
    }

    @Override
    public RequestType getType() {
        return RequestType.CLONE_BRANCH;
    }
}

