/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.classfile;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.property.DateTimeFactory;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.sequencer.SequencerOutput;
import org.modeshape.graph.sequencer.StreamSequencerContext;
import org.modeshape.sequencer.classfile.ClassFileRecorder;
import org.modeshape.sequencer.classfile.ClassFileSequencerLexicon;
import org.modeshape.sequencer.classfile.metadata.AnnotationMetadata;
import org.modeshape.sequencer.classfile.metadata.ClassMetadata;
import org.modeshape.sequencer.classfile.metadata.EnumMetadata;
import org.modeshape.sequencer.classfile.metadata.FieldMetadata;
import org.modeshape.sequencer.classfile.metadata.MethodMetadata;

public class DefaultClassFileRecorder
implements ClassFileRecorder {
    @Override
    public void recordClass(StreamSequencerContext context, SequencerOutput output, ClassMetadata classMetadata) {
        PathFactory pathFactory = this.pathFactoryFor(context);
        DateTimeFactory dateFactory = this.dateFactoryFor(context);
        Path classPath = this.pathFor(pathFactory, classMetadata);
        this.writeClassNode(output, pathFactory, dateFactory, classPath, classMetadata);
    }

    private DateTimeFactory dateFactoryFor(StreamSequencerContext context) {
        return context.getValueFactories().getDateFactory();
    }

    private PathFactory pathFactoryFor(StreamSequencerContext context) {
        return context.getValueFactories().getPathFactory();
    }

    private Path pathFor(PathFactory pathFactory, ClassMetadata cmd) {
        LinkedList<Path.Segment> segments = new LinkedList<Path.Segment>();
        for (String segment : cmd.getClassName().split("\\.")) {
            segments.add(pathFactory.createSegment(segment));
        }
        return pathFactory.createRelativePath(segments);
    }

    private void writeClassNode(SequencerOutput output, PathFactory pathFactory, DateTimeFactory dateFactory, Path classPath, ClassMetadata cmd) {
        output.setProperty(classPath, ClassFileSequencerLexicon.NAME, cmd.getClassName());
        output.setProperty(classPath, ClassFileSequencerLexicon.SEQUENCED_DATE, dateFactory.create());
        String superClassName = cmd.getSuperclassName();
        if (superClassName == null || superClassName.length() == 0) {
            superClassName = Object.class.getCanonicalName();
        }
        output.setProperty(classPath, ClassFileSequencerLexicon.SUPER_CLASS_NAME, superClassName);
        output.setProperty(classPath, ClassFileSequencerLexicon.VISIBILITY, cmd.getVisibility().getDescription());
        output.setProperty(classPath, ClassFileSequencerLexicon.ABSTRACT, cmd.isAbstract());
        output.setProperty(classPath, ClassFileSequencerLexicon.INTERFACE, cmd.isInterface());
        output.setProperty(classPath, ClassFileSequencerLexicon.FINAL, cmd.isFinal());
        output.setProperty(classPath, ClassFileSequencerLexicon.STRICT_FP, cmd.isStrictFp());
        output.setProperty(classPath, ClassFileSequencerLexicon.INTERFACES, (Object[])cmd.getInterfaces());
        Path constructorsPath = pathFactory.create(classPath, ClassFileSequencerLexicon.CONSTRUCTORS);
        output.setProperty(constructorsPath, JcrLexicon.PRIMARY_TYPE, ClassFileSequencerLexicon.CONSTRUCTORS);
        this.writeMethods(output, pathFactory, constructorsPath, cmd.getConstructors());
        Path methodsPath = pathFactory.create(classPath, ClassFileSequencerLexicon.METHODS);
        output.setProperty(methodsPath, JcrLexicon.PRIMARY_TYPE, ClassFileSequencerLexicon.METHODS);
        this.writeMethods(output, pathFactory, methodsPath, cmd.getMethods());
        this.writeFieldsNode(output, pathFactory, classPath, cmd.getFields());
        this.writeAnnotationsNode(output, pathFactory, classPath, cmd.getAnnotations());
        if (cmd instanceof EnumMetadata) {
            output.setProperty(classPath, JcrLexicon.PRIMARY_TYPE, ClassFileSequencerLexicon.ENUM);
            output.setProperty(classPath, ClassFileSequencerLexicon.ENUM_VALUES, ((EnumMetadata)cmd).getValues().toArray());
        } else {
            output.setProperty(classPath, JcrLexicon.PRIMARY_TYPE, ClassFileSequencerLexicon.CLASS);
        }
    }

    private void writeFieldsNode(SequencerOutput output, PathFactory pathFactory, Path classPath, List<FieldMetadata> fields) {
        Path fieldsPath = pathFactory.create(classPath, ClassFileSequencerLexicon.FIELDS);
        output.setProperty(fieldsPath, JcrLexicon.PRIMARY_TYPE, ClassFileSequencerLexicon.FIELDS);
        for (FieldMetadata field : fields) {
            Path fieldPath = pathFactory.create(fieldsPath, field.getName());
            output.setProperty(fieldPath, JcrLexicon.PRIMARY_TYPE, ClassFileSequencerLexicon.FIELD);
            output.setProperty(fieldPath, ClassFileSequencerLexicon.NAME, field.getName());
            output.setProperty(fieldPath, ClassFileSequencerLexicon.TYPE_CLASS_NAME, field.getTypeName());
            output.setProperty(fieldPath, ClassFileSequencerLexicon.VISIBILITY, field.getVisibility().getDescription());
            output.setProperty(classPath, ClassFileSequencerLexicon.STATIC, field.isStatic());
            output.setProperty(classPath, ClassFileSequencerLexicon.FINAL, field.isFinal());
            output.setProperty(classPath, ClassFileSequencerLexicon.TRANSIENT, field.isTransient());
            output.setProperty(classPath, ClassFileSequencerLexicon.VOLATILE, field.isVolatile());
            this.writeAnnotationsNode(output, pathFactory, fieldPath, field.getAnnotations());
        }
    }

    private void writeMethods(SequencerOutput output, PathFactory pathFactory, Path methodsPath, List<MethodMetadata> methods) {
        for (MethodMetadata method : methods) {
            Path methodPath = pathFactory.create(methodsPath, method.getId());
            output.setProperty(methodPath, JcrLexicon.PRIMARY_TYPE, ClassFileSequencerLexicon.METHOD);
            output.setProperty(methodPath, ClassFileSequencerLexicon.NAME, method.getName());
            output.setProperty(methodPath, ClassFileSequencerLexicon.RETURN_TYPE_CLASS_NAME, method.getReturnType());
            output.setProperty(methodPath, ClassFileSequencerLexicon.VISIBILITY, method.getVisibility().getDescription());
            output.setProperty(methodPath, ClassFileSequencerLexicon.STATIC, method.isStatic());
            output.setProperty(methodPath, ClassFileSequencerLexicon.FINAL, method.isFinal());
            output.setProperty(methodPath, ClassFileSequencerLexicon.ABSTRACT, method.isAbstract());
            output.setProperty(methodPath, ClassFileSequencerLexicon.STRICT_FP, method.isStrictFp());
            output.setProperty(methodPath, ClassFileSequencerLexicon.NATIVE, method.isNative());
            output.setProperty(methodPath, ClassFileSequencerLexicon.SYNCHRONIZED, method.isSynchronized());
            output.setProperty(methodPath, ClassFileSequencerLexicon.PARAMETERS, method.getParameters().toArray());
            this.writeAnnotationsNode(output, pathFactory, methodPath, method.getAnnotations());
        }
    }

    private void writeAnnotationsNode(SequencerOutput output, PathFactory pathFactory, Path parentPath, List<AnnotationMetadata> annotations) {
        Path annotationsPath = pathFactory.create(parentPath, ClassFileSequencerLexicon.ANNOTATIONS);
        output.setProperty(annotationsPath, JcrLexicon.PRIMARY_TYPE, ClassFileSequencerLexicon.ANNOTATIONS);
        for (AnnotationMetadata annotation : annotations) {
            Path annotationPath = pathFactory.create(parentPath, annotation.getAnnotationClassName());
            output.setProperty(annotationPath, JcrLexicon.PRIMARY_TYPE, ClassFileSequencerLexicon.ANNOTATION);
            for (Map.Entry<String, String> entry : annotation.getMemberValues().entrySet()) {
                Path annotationMemberPath = pathFactory.create(annotationPath, entry.getKey());
                output.setProperty(annotationMemberPath, JcrLexicon.PRIMARY_TYPE, ClassFileSequencerLexicon.ANNOTATION_MEMBER);
                output.setProperty(annotationMemberPath, ClassFileSequencerLexicon.NAME, entry.getKey());
                output.setProperty(annotationMemberPath, ClassFileSequencerLexicon.VALUE, entry.getValue());
            }
        }
    }
}

