/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.java;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.property.DateTimeFactory;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.sequencer.SequencerOutput;
import org.modeshape.graph.sequencer.StreamSequencerContext;
import org.modeshape.sequencer.classfile.ClassFileSequencerLexicon;
import org.modeshape.sequencer.classfile.metadata.Visibility;
import org.modeshape.sequencer.java.SourceFileRecorder;
import org.modeshape.sequencer.java.metadata.AnnotationMetadata;
import org.modeshape.sequencer.java.metadata.EnumMetadata;
import org.modeshape.sequencer.java.metadata.FieldMetadata;
import org.modeshape.sequencer.java.metadata.InterfaceMetadata;
import org.modeshape.sequencer.java.metadata.JavaMetadata;
import org.modeshape.sequencer.java.metadata.MethodMetadata;
import org.modeshape.sequencer.java.metadata.TypeMetadata;

public class ClassSourceFileRecorder
implements SourceFileRecorder {
    @Override
    public void record(StreamSequencerContext context, SequencerOutput output, JavaMetadata javaMetadata) {
        PathFactory pathFactory = this.pathFactoryFor(context);
        DateTimeFactory dateFactory = this.dateFactoryFor(context);
        this.writeJavaMetadata(output, pathFactory, dateFactory, javaMetadata);
    }

    private DateTimeFactory dateFactoryFor(StreamSequencerContext context) {
        return context.getValueFactories().getDateFactory();
    }

    private PathFactory pathFactoryFor(StreamSequencerContext context) {
        return context.getValueFactories().getPathFactory();
    }

    private Path pathFor(PathFactory pathFactory, TypeMetadata tmd) {
        LinkedList<Path.Segment> segments = new LinkedList<Path.Segment>();
        for (String segment : tmd.getName().split("\\.")) {
            segments.add(pathFactory.createSegment(segment));
        }
        return pathFactory.createRelativePath(segments);
    }

    private void writeJavaMetadata(SequencerOutput output, PathFactory pathFactory, DateTimeFactory dateFactory, JavaMetadata javaMetadata) {
        for (TypeMetadata typeMetadata : javaMetadata.getTypeMetadata()) {
            this.writeClassMetadata(output, pathFactory, dateFactory, this.pathFor(pathFactory, typeMetadata), typeMetadata);
        }
    }

    private void writeClassMetadata(SequencerOutput output, PathFactory pathFactory, DateTimeFactory dateFactory, Path classPath, TypeMetadata cmd) {
        int numberOfMethods = cmd.getMethods().size();
        ArrayList<MethodMetadata> methods = new ArrayList<MethodMetadata>(numberOfMethods);
        ArrayList<MethodMetadata> ctors = new ArrayList<MethodMetadata>(numberOfMethods);
        for (MethodMetadata method : cmd.getMethods()) {
            if (method.isContructor()) {
                ctors.add(method);
                continue;
            }
            methods.add(method);
        }
        output.setProperty(classPath, ClassFileSequencerLexicon.NAME, cmd.getName());
        output.setProperty(classPath, ClassFileSequencerLexicon.SEQUENCED_DATE, dateFactory.create());
        String superClassName = cmd.getSuperClassName();
        if (superClassName == null || superClassName.length() == 0) {
            superClassName = Object.class.getCanonicalName();
        }
        output.setProperty(classPath, ClassFileSequencerLexicon.SUPER_CLASS_NAME, superClassName);
        output.setProperty(classPath, ClassFileSequencerLexicon.VISIBILITY, this.visibilityFor(cmd).getDescription());
        output.setProperty(classPath, ClassFileSequencerLexicon.ABSTRACT, cmd.hasModifierNamed("abstract"));
        output.setProperty(classPath, ClassFileSequencerLexicon.INTERFACE, cmd instanceof InterfaceMetadata);
        output.setProperty(classPath, ClassFileSequencerLexicon.FINAL, cmd.hasModifierNamed("final"));
        output.setProperty(classPath, ClassFileSequencerLexicon.STRICT_FP, cmd.hasModifierNamed("strictfp"));
        output.setProperty(classPath, ClassFileSequencerLexicon.INTERFACES, cmd.getInterfaceNames().toArray());
        Path constructorsPath = pathFactory.create(classPath, ClassFileSequencerLexicon.CONSTRUCTORS);
        output.setProperty(constructorsPath, JcrLexicon.PRIMARY_TYPE, ClassFileSequencerLexicon.CONSTRUCTORS);
        this.writeMethods(output, pathFactory, constructorsPath, ctors);
        Path methodsPath = pathFactory.create(classPath, ClassFileSequencerLexicon.METHODS);
        output.setProperty(methodsPath, JcrLexicon.PRIMARY_TYPE, ClassFileSequencerLexicon.METHODS);
        this.writeMethods(output, pathFactory, methodsPath, methods);
        this.writeFieldsNode(output, pathFactory, classPath, cmd.getFields());
        this.writeAnnotationsNode(output, pathFactory, classPath, cmd.getAnnotations());
        if (cmd instanceof EnumMetadata) {
            output.setProperty(classPath, JcrLexicon.PRIMARY_TYPE, ClassFileSequencerLexicon.ENUM);
            output.setProperty(classPath, ClassFileSequencerLexicon.ENUM_VALUES, ((EnumMetadata)cmd).getValues().toArray());
        } else {
            output.setProperty(classPath, JcrLexicon.PRIMARY_TYPE, ClassFileSequencerLexicon.CLASS);
        }
    }

    private Visibility visibilityFor(TypeMetadata cmd) {
        if (cmd.hasModifierNamed("public")) {
            return Visibility.PUBLIC;
        }
        if (cmd.hasModifierNamed("protected")) {
            return Visibility.PROTECTED;
        }
        if (cmd.hasModifierNamed("private")) {
            return Visibility.PRIVATE;
        }
        return Visibility.PACKAGE;
    }

    private Visibility visibilityFor(FieldMetadata cmd) {
        if (cmd.hasModifierNamed("public")) {
            return Visibility.PUBLIC;
        }
        if (cmd.hasModifierNamed("protected")) {
            return Visibility.PROTECTED;
        }
        if (cmd.hasModifierNamed("private")) {
            return Visibility.PRIVATE;
        }
        return Visibility.PACKAGE;
    }

    private Visibility visibilityFor(MethodMetadata cmd) {
        if (cmd.hasModifierNamed("public")) {
            return Visibility.PUBLIC;
        }
        if (cmd.hasModifierNamed("protected")) {
            return Visibility.PROTECTED;
        }
        if (cmd.hasModifierNamed("private")) {
            return Visibility.PRIVATE;
        }
        return Visibility.PACKAGE;
    }

    private void writeAnnotationsNode(SequencerOutput output, PathFactory pathFactory, Path parentPath, List<AnnotationMetadata> annotations) {
        Path annotationsPath = pathFactory.create(parentPath, ClassFileSequencerLexicon.ANNOTATIONS);
        output.setProperty(annotationsPath, JcrLexicon.PRIMARY_TYPE, ClassFileSequencerLexicon.ANNOTATIONS);
        for (AnnotationMetadata annotation : annotations) {
            Path annotationPath = pathFactory.create(annotationsPath, annotation.getName());
            output.setProperty(annotationPath, JcrLexicon.PRIMARY_TYPE, ClassFileSequencerLexicon.ANNOTATION);
            for (Map.Entry<String, String> entry : annotation.getMemberValues().entrySet()) {
                String key = entry.getKey();
                if (key == null) {
                    key = "default";
                }
                Path annotationMemberPath = pathFactory.create(annotationPath, key);
                output.setProperty(annotationMemberPath, JcrLexicon.PRIMARY_TYPE, ClassFileSequencerLexicon.ANNOTATION_MEMBER);
                output.setProperty(annotationMemberPath, ClassFileSequencerLexicon.NAME, entry.getKey());
                output.setProperty(annotationMemberPath, ClassFileSequencerLexicon.VALUE, entry.getValue());
            }
        }
    }

    private void writeFieldsNode(SequencerOutput output, PathFactory pathFactory, Path classPath, List<FieldMetadata> fields) {
        Path fieldsPath = pathFactory.create(classPath, ClassFileSequencerLexicon.FIELDS);
        output.setProperty(fieldsPath, JcrLexicon.PRIMARY_TYPE, ClassFileSequencerLexicon.FIELDS);
        for (FieldMetadata field : fields) {
            Path fieldPath = pathFactory.create(fieldsPath, field.getName());
            output.setProperty(fieldPath, JcrLexicon.PRIMARY_TYPE, ClassFileSequencerLexicon.FIELD);
            output.setProperty(fieldPath, ClassFileSequencerLexicon.NAME, field.getName());
            output.setProperty(fieldPath, ClassFileSequencerLexicon.TYPE_CLASS_NAME, field.getType());
            output.setProperty(fieldPath, ClassFileSequencerLexicon.VISIBILITY, this.visibilityFor(field).getDescription());
            output.setProperty(classPath, ClassFileSequencerLexicon.STATIC, field.hasModifierNamed("static"));
            output.setProperty(classPath, ClassFileSequencerLexicon.FINAL, field.hasModifierNamed("final"));
            output.setProperty(classPath, ClassFileSequencerLexicon.TRANSIENT, field.hasModifierNamed("transient"));
            output.setProperty(classPath, ClassFileSequencerLexicon.VOLATILE, field.hasModifierNamed("volatile"));
            this.writeAnnotationsNode(output, pathFactory, fieldPath, field.getAnnotations());
        }
    }

    private void writeMethods(SequencerOutput output, PathFactory pathFactory, Path methodsPath, List<MethodMetadata> methods) {
        for (MethodMetadata method : methods) {
            Path methodPath = pathFactory.create(methodsPath, method.getId());
            output.setProperty(methodPath, JcrLexicon.PRIMARY_TYPE, ClassFileSequencerLexicon.METHOD);
            output.setProperty(methodPath, ClassFileSequencerLexicon.NAME, method.getName());
            output.setProperty(methodPath, ClassFileSequencerLexicon.RETURN_TYPE_CLASS_NAME, method.getReturnTypeName());
            output.setProperty(methodPath, ClassFileSequencerLexicon.VISIBILITY, this.visibilityFor(method).getDescription());
            output.setProperty(methodPath, ClassFileSequencerLexicon.STATIC, method.hasModifierNamed("static"));
            output.setProperty(methodPath, ClassFileSequencerLexicon.FINAL, method.hasModifierNamed("final"));
            output.setProperty(methodPath, ClassFileSequencerLexicon.ABSTRACT, method.hasModifierNamed("abstract"));
            output.setProperty(methodPath, ClassFileSequencerLexicon.STRICT_FP, method.hasModifierNamed("strictfp"));
            output.setProperty(methodPath, ClassFileSequencerLexicon.NATIVE, method.hasModifierNamed("native"));
            output.setProperty(methodPath, ClassFileSequencerLexicon.SYNCHRONIZED, method.hasModifierNamed("synchronized"));
            output.setProperty(methodPath, ClassFileSequencerLexicon.PARAMETERS, method.getParameterTypes().toArray());
            this.writeAnnotationsNode(output, pathFactory, methodPath, method.getAnnotations());
        }
    }
}

