/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.jcache.interceptor;

import java.util.Collection;
import java.util.Collections;
import javax.cache.annotation.CacheInvocationContext;
import org.springframework.cache.Cache;
import org.springframework.cache.interceptor.CacheOperationInvocationContext;
import org.springframework.cache.interceptor.CacheResolver;
import org.springframework.cache.jcache.JCacheCache;
import org.springframework.util.Assert;

class CacheResolverAdapter
implements CacheResolver {
    private final javax.cache.annotation.CacheResolver target;

    public CacheResolverAdapter(javax.cache.annotation.CacheResolver target) {
        Assert.notNull(target, "JSR-107 cache resolver must be set.");
        this.target = target;
    }

    protected javax.cache.annotation.CacheResolver getTarget() {
        return this.target;
    }

    @Override
    public Collection<? extends Cache> resolveCaches(CacheOperationInvocationContext<?> context) {
        if (!(context instanceof CacheInvocationContext)) {
            throw new IllegalStateException("Unexpected context " + context);
        }
        CacheInvocationContext cacheInvocationContext = (CacheInvocationContext)context;
        javax.cache.Cache cache = this.target.resolveCache(cacheInvocationContext);
        Assert.notNull(cache, "Cannot resolve cache for '" + context + "' using '" + this.target + "'");
        return Collections.singleton(new JCacheCache((javax.cache.Cache<Object, Object>)cache));
    }
}

