DELIMITER $$

DROP PROCEDURE IF EXISTS librarycardnumbermappingaudit $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE librarycardnumbermappingaudit()

BEGIN
  
  -- Add the email table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='library_card_number_mapping_history')) THEN
    

CREATE TABLE `library_card_number_mapping_history` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
   `REV` int(11) NOT NULL,
   `REVTYPE` tinyint(4) DEFAULT NULL,
  `userTypeId` bigint(20) NOT NULL,
  `libraryCardNumberType` varchar(255) NOT NULL DEFAULT 'null',
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
	PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

	
  END IF;

END $$

-- Execute the stored procedure
CALL librarycardnumbermappingaudit $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS librarycardnumbermappingaudit $$
 
DELIMITER ;