DELIMITER $$
DROP PROCEDURE IF EXISTS V20220307123804__Create_question_paper_details_history $$
CREATE PROCEDURE V20220307123804__Create_question_paper_details_history()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='question_paper_details_history')) THEN 
CREATE TABLE `question_paper_details_history` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `questionPaperId` bigint DEFAULT NULL,
  `questionDescription` varchar(255) DEFAULT NULL,
  `courseTopicId` bigint DEFAULT NULL,
  `questionType` varchar(255) DEFAULT NULL COMMENT 'Match the following,Sngle correct from,Multiple choices,Multiple correct from multiple choices,Fill in the blanks, \ntrue or false, true or false with reasoning, theory, sums, measurement & characteristics identification.',
  `questionText` text,
  `questionImage` varchar(255) DEFAULT NULL,
  `structureLevelTwoId` bigint DEFAULT NULL,
  `structureLevelThreeId` bigint DEFAULT NULL,
  `structureLeafNodeId` bigint DEFAULT NULL,
  `answerText` text,
  `answerImage` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
   PRIMARY KEY (`id`,`REV`)
   ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

END IF; 

END $$
CALL V20220307123804__Create_question_paper_details_history () $$ 
DROP PROCEDURE IF EXISTS V20220307123804__Create_question_paper_details_history $$ 
DELIMITER ;
