DELIMITER $$
DROP PROCEDURE IF EXISTS V20221230114712__Create_EmployeeAdditionalInformationAudit $$
CREATE PROCEDURE V20221230114712__Create_EmployeeAdditionalInformationAudit()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='employees_additional_information_history')) THEN 
CREATE TABLE `employees_additional_information_history` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT, 
   `REV` bigint(20) NOT NULL,
	`REVTYPE` tinyint(4) DEFAULT NULL,
	`userId` BIGINT,
   
	`numberOfArticlesInPeerReviewedOrRefereedJournals` BIGINT,
   `numberOfArticlesInPeerReviewedOrRefereedJournalsAsFirst` BIGINT,
   `numberOfPublishedConferencePapers` BIGINT,
   `numberOfPublishedConferencePapersAsFirst` BIGINT,
   `numberOfConferencesAndSymposia` BIGINT,
   `numberOfConferencesAndSymposiaAsFirst` BIGINT,
   `scopusGoogleProfileOfExternalExaminer`TEXT,
   `numberOfPhDsSupervisedOverLastFiveYears` BIGINT,
   `numberOfCurrentPhDStudents` BIGINT,
   `numberOfPHDsCompleted` BIGINT,
   `numberOfMasterDegreeSupervisedOverFiveYears` BIGINT,
   `numberOfCurrentMasterStudents` BIGINT,
   `numberOfMasterDegreeCompleted` BIGINT,
   `nominationOfInternationalExaminer` TEXT,
   `amendmentOfExaminer` TEXT,
   `nominationOfInternalExaminer` TEXT,
   `nominationOfExternalExaminer` TEXT,
   `deviationFromNormalRequirements` TEXT,
   `abbreviatedCurriculumVitaeInformation` TEXT,
   `approvalBody` BIGINT,
   `approvalBodyName` Varchar(255),
   `approvalDate` Date,
   
   `lastUpdate` datetime DEFAULT NULL,
 `lastUpdatedBy` bigint(20) DEFAULT NULL,
 PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF;  

END $$
CALL V20221230114712__Create_EmployeeAdditionalInformationAudit () $$ 
DROP PROCEDURE IF EXISTS V20221230114712__Create_EmployeeAdditionalInformationAudit $$ 
DELIMITER ;