DELIMITER $$
DROP PROCEDURE IF EXISTS V20230801113034__Create_ApplicantPermitDetailHistoryTable $$
CREATE PROCEDURE V20230801113034__Create_ApplicantPermitDetailHistoryTable()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='applicant_permit_detail_history')) THEN 
CREATE TABLE `applicant_permit_detail_history` (
 	`id` BIGINT(20) NOT NULL,
 	`REV` BIGINT(20) NOT NULL,
  	`REVTYPE` tinyint(4) NULL DEFAULT NULL,
  	`applicantPersonId` BIGINT(20) NOT NULL,
    `permitTypeId` BIGINT(20) NOT NULL,
    `cantonOfIssueId` BIGINT(20) NULL DEFAULT NULL,
    `countryOfIssueId` BIGINT(20) NULL DEFAULT NULL,
    `isPermitWithFamily` BIT(1) NOT NULL DEFAULT b'0',
    `permitStartDate` DATE NULL DEFAULT NULL,
    `permitExpirationDate` DATE NULL DEFAULT NULL,
    `permitCancellationDate` DATE NULL DEFAULT NULL,
    `dateOfDepartureAnnouncement` DATE NULL DEFAULT NULL,
    `reasonForPermitCancellation` VARCHAR(255) NULL DEFAULT NULL,
    `dateSubmittedToAuthorities` DATE NULL DEFAULT NULL,
    `methodOfSubmissionId` BIGINT(20) NULL DEFAULT NULL,
    `dateIssued` DATE NULL DEFAULT NULL,
    `dateCollected` DATE NULL DEFAULT NULL,
    `isPrimary` BIT(1) NOT NULL DEFAULT b'0',
  	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  	`lastUpdatedBy` BIGINT(20) NOT NULL,
  	PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

END $$
CALL V20230801113034__Create_ApplicantPermitDetailHistoryTable () $$ 
DROP PROCEDURE IF EXISTS V20230801113034__Create_ApplicantPermitDetailHistoryTable $$ 
DELIMITER ;