DELIMITER $$

-- Drop procedure if it exists
DROP PROCEDURE IF EXISTS V20250805174918__Alter_AlterUserSocialHistory $$

-- Create procedure
CREATE PROCEDURE V20250805174918__Alter_AlterUserSocialHistory()
BEGIN

    -- Add 'user_access_token' column if missing
    IF NOT EXISTS (
        SELECT * FROM information_schema.COLUMNS
        WHERE table_schema = DATABASE()
          AND table_name = 'users_social_history'
          AND column_name = 'userAccessToken'
    ) THEN
        ALTER TABLE `users_social_history`
        ADD COLUMN `userAccessToken` VARCHAR(4096) NULL;
    END IF;

    -- Add 'token_expiry' column if missing
    IF NOT EXISTS (
        SELECT * FROM information_schema.COLUMNS
        WHERE table_schema = DATABASE()
          AND table_name = 'users_social_history'
          AND column_name = 'tokenExpiry'
    ) THEN
        ALTER TABLE `users_social_history`
        ADD COLUMN `tokenExpiry` TIMESTAMP NULL;
    END IF;

END $$

-- Execute procedure
CALL V20250805174918__Alter_AlterUserSocialHistory() $$

-- Drop procedure after execution
DROP PROCEDURE IF EXISTS V20250805174918__Alter_AlterUserSocialHistory $$

DELIMITER ;