CREATE OR REPLACE
    ALGORITHM = UNDEFINED 
    DEFINER = `root`@`localhost` 
    SQL SECURITY DEFINER
VIEW `evaluation_plan_specific` AS
    select 
        `programs`.`id` AS `programId`,
        `batches`.`id` AS `batchId`,
        `examination_result`.`admissionId` AS `admissionId`,
        `users`.`printName` AS `printName`,
        sum(`eval_seq_detail`.`maxMarks`) AS `markObtainedFrom`,
        sum(`examination_result`.`finalMarks`) AS `markObtained`,
        avg(`examination_result`.`gradePoints`) AS `gradePoint`,
        `evaluation_plan`.`id` AS `evaluationPlanId`,
        `evaluation_plan`.`evaluationPlanNumber` AS `evaluationPlanNumber`
    from
        ((((((((((`examination_result`
        left join `admission` ON ((`examination_result`.`admissionId` = `admission`.`id`)))
        left join `students` ON ((`admission`.`studentId` = `students`.`userId`)))
        left join `users` ON ((`students`.`userId` = `users`.`id`)))
        left join `batches` ON ((`admission`.`batchId` = `batches`.`id`)))
        left join `programs` ON ((`admission`.`programId` = `programs`.`id`)))
        left join `eval_seq_detail` ON ((`examination_result`.`evaluationDetailSequenceId` = `eval_seq_detail`.`id`)))
        left join `evaluation_sequence` ON ((`eval_seq_detail`.`evalSequenceId` = `evaluation_sequence`.`id`)))
        left join `evaluation_plan_level_two` ON ((`evaluation_sequence`.`evalPlanLevelTwoId` = `evaluation_plan_level_two`.`id`)))
        left join `evaluation_plan_level_one` ON ((`evaluation_plan_level_two`.`evalPlanLevelOneId` = `evaluation_plan_level_one`.`id`)))
        left join `evaluation_plan` ON ((`evaluation_plan_level_one`.`evaluationPlanId` = `evaluation_plan`.`id`)))
    group by `evaluation_plan`.`id` , `examination_result`.`admissionId`