
CREATE TABLE email_server_configuration(
	id BIGINT(20) PRIMARY KEY AUTO_INCREMENT,
	userName VARCHAR(255),
	password VARCHAR(255),
	senderEmailAddress VARCHAR(255),
	host VARCHAR(255),
	port VARCHAR(255),
	isActive BIT(1),
	lastUpdatedBy BIGINT(20),
	lastUpdate TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
	FOREIGN KEY (lastUpdatedBy) REFERENCES users(id)
);

CREATE TABLE sms_gateway_configuration(
	id BIGINT(20) PRIMARY KEY AUTO_INCREMENT,
	userName VARCHAR(255),
	password VARCHAR(255),
	senderId VARCHAR(255),
	apiPassword VARCHAR(255),
	isActive BIT(1),
	hostURL VARCHAR(255),
	lastUpdatedBy BIGINT(20),
	lastUpdate TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
	FOREIGN KEY (lastUpdatedBy) REFERENCES users(id)
);

SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);

INSERT INTO `standard_master` (`tableName`, `masterName`, `whetherChild`, `whetherParent`, `lastUpdatedBy`,`lastUpdate`) VALUES 
('email_server_configuration', 'EMAIL_SERVER_CONFIGURATION', 0, 0, '1',@currentTimeStamp);

SET @masterId = (SELECT max(id) from standard_master);

INSERT INTO `standard_master_items` (`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`,`lastUpdate`) 
VALUES 
('userName', 'USER_NAME', @masterId, 'Varchar', '1', 0, 0, 0, 1, '1',@currentTimeStamp),
('password', 'PASSWORD', @masterId, 'Varchar', '1', 0, 0, 0, 1, '1',@currentTimeStamp),
('senderEmailAddress', 'SENDER_EMAIL_ADDRESS', @masterId, 'Varchar', '1', 0, 0, 0, 1, '1',@currentTimeStamp),
('host', 'HOST', @masterId, 'Varchar', '1', 0, 0, 0, 1, '1',@currentTimeStamp),
('port', 'PORT', @masterId, 'Varchar', '1', 0, 0, 0, 1, '1',@currentTimeStamp),
('isActive', 'IS_ACTIVE', @masterId, 'Boolean', '1', 0, 0, 0, 1, '1',@currentTimeStamp);

INSERT INTO `standard_master` (`tableName`, `masterName`, `whetherChild`, `whetherParent`, `lastUpdatedBy`,`lastUpdate`) VALUES 
('sms_gateway_configuration', 'SMS_GATEWAY_CONFIGURATION', 0, 0, '1',@currentTimeStamp);

SET @masterId = (SELECT max(id) from standard_master);

INSERT INTO `standard_master_items` (`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`,`lastUpdate`) VALUES 
('userName', 'USER_NAME', @masterId, 'Varchar', '1', 0, 0, 0, 1, '1',@currentTimeStamp),
('password', 'PASSWORD', @masterId, 'Varchar', '2', 0, 0, 0, 1, '1',@currentTimeStamp),
('senderId', 'SENDER_ID', @masterId, 'Varchar', '3', 0, 0, 0, 1, '1',@currentTimeStamp),
('apiPassword', 'API_PASSWORD', @masterId, 'Varchar', '4', 0, 0, 0, 1, '1',@currentTimeStamp),
('isActive', 'IS_ACTIVE', @masterId, 'Boolean', '5', 0, 0, 0, 1, '1',@currentTimeStamp),
('hostURL', 'HOST_URL', @masterId, 'Varchar', '6', 0, 0, 0, 1, '1',@currentTimeStamp);
