CREATE 
     OR REPLACE ALGORITHM = UNDEFINED 
    DEFINER = `root`@`localhost` 
    SQL SECURITY DEFINER
VIEW `trans_journey_assignment_report` AS
    select 
        `trans_journey_assignment`.`id` AS `JOURNEY_ASSIGNMENT_ID`,
        `trans_journey_assignment`.`dateOfJourney` AS `DATE_OF_JOURNEY`,
        `trans_route`.`routeName` AS `ROUTE_NAME`,
        `trans_service_route`.`serviceName` AS `SERVICE_ROUTE_NAME`,
        `trans_vehicle`.`vehicleNumber` AS `VEHICLE_NUMBER`,
        (case
            when (`users`.`printName` is not null) then `users`.`printName`
            else `trans_service_route_users`.`userName`
        end) AS `USER_NAME`,
        `trans_route_location`.`locationName` AS `STOP_NAME`,
        `trans_journey_assignment`.`assignStatus` AS `ORIGINAL_STATUS`,
        `trans_journey_assignment`.`completionStatus` AS `CURRENT_STATUS`,
        `trans_vehicle`.`id` AS `VEHICLE_ID`,
        `trans_route`.`id` AS `ROUTE_ID`,
        `trans_service_route`.`id` AS `SERVICE_ROUTE_ID`,
        `trans_user_attendance`.`serviceRouteUserId` AS `SERVICE_ROUTE_USER_ID`,
        `trans_service_route_stops`.`id` AS `SERVICE_ROUTE_USER_STOP_ID`
    from
        ((((((((((`trans_journey_assignment`
        left join `trans_service_route` ON ((`trans_journey_assignment`.`serviceRouteId` = `trans_service_route`.`id`)))
        left join `trans_vehicle` ON ((`trans_journey_assignment`.`vehicleId` = `trans_vehicle`.`id`)))
        left join `trans_service_route_users` ON ((`trans_service_route_users`.`serviceRouteId` = `trans_service_route`.`id`)))
        left join `users` ON ((`trans_service_route_users`.`userId` = `users`.`id`)))
        left join `trans_route` ON ((`trans_service_route`.`routeId` = `trans_route`.`id`)))
        left join `students` ON ((`students`.`userId` = `users`.`id`)))
        left join `staffs` ON ((`staffs`.`userId` = `users`.`id`)))
        left join `trans_service_route_stops` ON ((`trans_service_route_users`.`serviceRouteStopId` = `trans_service_route_stops`.`id`)))
        left join `trans_route_location` ON ((`trans_service_route_stops`.`stopLocationId` = `trans_route_location`.`id`)))
        left join `trans_user_attendance` ON (((`trans_journey_assignment`.`id` = `trans_user_attendance`.`journeyAssignmentId`)
            and (`trans_service_route_users`.`id` = `trans_user_attendance`.`serviceRouteUserId`))))
    where
        (`trans_journey_assignment`.`dateOfJourney` < now());
