CREATE 
     OR REPLACE ALGORITHM = UNDEFINED 
    DEFINER = `root`@`localhost` 
    SQL SECURITY DEFINER
VIEW `student_period_report` AS
    select 
        `admission`.`id` AS `admissionId`,
        `admission`.`studentId` AS `studentId`,
        `evaluation_period_rank`.`id` AS `periodRankId`,
        `admission`.`code` AS `admissionCode`,
        `programs`.`id` AS `programId`,
        `programs`.`programName` AS `programName`,
        `batches`.`id` AS `batchId`,
        `batches`.`batchName` AS `batchName`,
        `prog_batch_period_config`.`id` AS `periodId`,
        `prog_batch_period_config`.`programPeriodName` AS `periodName`,
        `sections`.`id` AS `sectionId`,
        `sections`.`sectionCode` AS `sectionName`,
        count(distinct `student_course_enrollment`.`courseVarientId`) AS `totalNoOfCourse`,
        count(distinct (case
                when (`student_course_enrollment`.`whetherOptional` = 0) then `student_course_enrollment`.`courseVarientId`
            end)) AS `mandatoryCourseCount`,
        count(distinct (case
                when (`student_course_enrollment`.`whetherOptional` = 1) then `student_course_enrollment`.`courseVarientId`
            end)) AS `optionalCourseCount`,
        (case
            when isnull(`evaluation_period_rank`.`obtainedMarks`) then `evaluation_period_rank`.`sgpa`
            else `evaluation_period_rank`.`obtainedMarks`
        end) AS `SGPAORMarks`,
        `evaluation_period_rank`.`status` AS `ResultStatus`,
        `marksheet_job_details`.`marksheetPath` AS `marksheetPath`
    from
        ((((((((`program_batch_students`
        left join `admission` ON ((`program_batch_students`.`admissionId` = `admission`.`id`)))
        left join `prog_batch_period_config` ON ((`program_batch_students`.`progBatchPeriodConfigId` = `prog_batch_period_config`.`id`)))
        left join `batches` ON ((`program_batch_students`.`programBatchId` = `batches`.`id`)))
        left join `programs` ON ((`batches`.`programId` = `programs`.`id`)))
        left join `evaluation_period_rank` ON ((`evaluation_period_rank`.`admissionId` = `admission`.`id`) and (evaluation_period_rank.periodId=prog_batch_period_config.id)))
        left join `student_course_enrollment` ON ((`student_course_enrollment`.`admissionId` = `admission`.`id`)))
        left join `sections` ON ((`student_course_enrollment`.`sectionId` = `sections`.`id`)))
        left join `marksheet_job_details` ON (((`marksheet_job_details`.`admissionId` = `admission`.`id`)
            and (`marksheet_job_details`.`periodId` = `prog_batch_period_config`.`id`))))
    group by `prog_batch_period_config`.`id` , `admission`.`id`;
