CREATE TABLE `hostel_room_type` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `roomType` varchar(60) DEFAULT NULL,
  `feePlanRuleStageId` bigint(20) DEFAULT NULL,
  `status` varchar(10) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fkh_feeplanrulestage_idx` (`feePlanRuleStageId`),
  KEY `fkh_roomtypeupdateby_idx` (`lastUpdatedBy`),
  CONSTRAINT `fkh_feeplanrulestage` FOREIGN KEY (`feePlanRuleStageId`) REFERENCES `fee_plan_rule_stage` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fkh_roomtypeupdateby` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `hostel_restriction_type` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `restrictionType` varchar(60) DEFAULT NULL,
  `gender` varchar(20) DEFAULT NULL,
  `userGroupId` bigint(20) DEFAULT NULL,
  `status` varchar(10) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fkh_usergroup_idx` (`userGroupId`),
  KEY `fkh_restrictionupdateby_idx` (`lastUpdatedBy`),
  CONSTRAINT `fkh_restrictionupdateby` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fkh_usergroup` FOREIGN KEY (`userGroupId`) REFERENCES `user_groups` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `hostel_cancellation_reason` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `itemCode` varchar(255) NOT NULL,
  `itemValue` varchar(255) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_hostel_cancellation_reason_updateby_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_hostel_cancellation_reason_updateby` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `hostel_checkout_reason` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `itemCode` varchar(255) NOT NULL,
  `itemValue` varchar(255) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_hostel_checkout_reason_updateby_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_hostel_checkout_reason_updateby` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `hostel_status_change_reason` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `itemCode` varchar(255) NOT NULL,
  `itemValue` varchar(255) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_hostel_status_change_reason_updateby_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_hostel_status_change_reason_updateby` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `hostel` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `resourceId` bigint(20) NOT NULL,
  `restrictionTypeId` bigint(20) DEFAULT NULL,
  `ownership` varchar(20) DEFAULT NULL,
  `leaseEndDate` date DEFAULT NULL,
  `startDate` date DEFAULT NULL,
  `closureDate` date DEFAULT NULL,
  `status` varchar(10) DEFAULT NULL,
  `managerId` bigint(20) DEFAULT NULL,
  `wardenId` bigint(20) DEFAULT NULL,
  `phoneCountryCode` varchar(10) DEFAULT NULL,
  `phoneAreaCode` int(11) DEFAULT NULL,
  `phoneNo` varchar(15) DEFAULT NULL,
  `cellNo` bigint(20) DEFAULT NULL,
  `cellCountryCode` char(10) DEFAULT NULL,
  `emailId` varchar(100) DEFAULT NULL,
  `remarks` text,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fkh_resource_idx` (`resourceId`),
  KEY `fkh_restrictiontype_idx` (`restrictionTypeId`),
  KEY `fkh_manager_idx` (`managerId`),
  KEY `fkh_warden_idx` (`wardenId`),
  KEY `fkh_hostelupdateby_idx` (`lastUpdatedBy`),
  CONSTRAINT `fkh_hostelupdateby` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fkh_manager` FOREIGN KEY (`managerId`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fkh_resource` FOREIGN KEY (`resourceId`) REFERENCES `resources` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fkh_restrictiontype` FOREIGN KEY (`restrictionTypeId`) REFERENCES `hostel_restriction_type` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fkh_warden` FOREIGN KEY (`wardenId`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `hostel_address` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `addressId` bigint(20) DEFAULT NULL,
  `hostelId` bigint(20) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fkh_hosreladress_idx` (`addressId`),
  KEY `fkh_hosteladd_idx` (`hostelId`),
  KEY `fkh_updatedby_idx` (`lastUpdatedBy`),
  CONSTRAINT `fkh_hosreladress` FOREIGN KEY (`addressId`) REFERENCES `address` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fkh_hosteladd` FOREIGN KEY (`hostelId`) REFERENCES `hostel` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fkh_updatedby` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `hostel_documents` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `documentId` bigint(20) NOT NULL,
  `hostelId` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fkh_hosteldocument_idx` (`documentId`),
  KEY `fkh_hosteldoc_idx` (`hostelId`),
  KEY `fkh_hosteldocupdated_idx` (`lastUpdatedBy`),
  CONSTRAINT `fkh_hosteldoc` FOREIGN KEY (`hostelId`) REFERENCES `hostel` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fkh_hosteldocument` FOREIGN KEY (`documentId`) REFERENCES `documents` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fkh_hosteldocupdated` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `hostel_building` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `resourceId` bigint(20) NOT NULL,
  `hostelId` bigint(20) NOT NULL,
  `restrictionTypeId` bigint(20) DEFAULT NULL,
  `startDate` date DEFAULT NULL,
  `closureDate` date DEFAULT NULL,
  `status` varchar(10) DEFAULT NULL,
  `wardenId` bigint(20) DEFAULT NULL,
  `phoneCountryCode` varchar(10) DEFAULT NULL,
  `phoneAreaCode` int(11) DEFAULT NULL,
  `phoneNo` varchar(15) DEFAULT NULL,
  `cellNo` bigint(20) DEFAULT NULL,
  `cellCountryCode` char(10) DEFAULT NULL,
  `emailId` varchar(100) DEFAULT NULL,
  `remarks` text,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fkh_resourcebuild_idx` (`resourceId`),
  KEY `fkh_hostel_1_idx` (`hostelId`),
  KEY `fkh_buildrestriction_idx` (`restrictionTypeId`),
  KEY `fkh_buildwarden_idx` (`wardenId`),
  KEY `fkh_buildupdateby_idx` (`lastUpdatedBy`),
  CONSTRAINT `fkh_buildrestriction` FOREIGN KEY (`restrictionTypeId`) REFERENCES `hostel_restriction_type` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fkh_buildupdateby` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fkh_buildwarden` FOREIGN KEY (`wardenId`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fkh_hostel_1` FOREIGN KEY (`hostelId`) REFERENCES `hostel` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fkh_resourcebuild` FOREIGN KEY (`resourceId`) REFERENCES `resources` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `hostel_floor` (
  `id` bigint(20) NOT NULL,
  `resourceId` bigint(20) NOT NULL,
  `buildinglId` bigint(20) NOT NULL,
  `floorNumber` varchar(60) DEFAULT NULL,
  `restrictionTypeId` bigint(20) DEFAULT NULL,
  `status` varchar(10) DEFAULT NULL,
  `remarks` text,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_hostel_resource_idx` (`resourceId`),
  KEY `fk_hostel_build_idx` (`buildinglId`),
  KEY `fk_hostel_floor_restriction_idx` (`restrictionTypeId`),
  KEY `fk_hostel_floor_updateby_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_hostel_build` FOREIGN KEY (`buildinglId`) REFERENCES `hostel_building` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_hostel_floor_restriction` FOREIGN KEY (`restrictionTypeId`) REFERENCES `hostel_restriction_type` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_hostel_floor_updateby` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_hostel_resource` FOREIGN KEY (`resourceId`) REFERENCES `resources` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `hostel_room` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `resourceId` bigint(20) NOT NULL,
  `floorId` bigint(20) DEFAULT NULL,
  `roomNumber` varchar(45) DEFAULT NULL,
  `roomTypeId` bigint(20) DEFAULT NULL,
  `numberOfBeds` int(11) DEFAULT NULL,
  `restrictionTypeId` bigint(20) DEFAULT NULL,
  `roomStatus` varchar(45) DEFAULT NULL,
  `statusChnageDate` date DEFAULT NULL,
  `statusChnageReasonId` bigint(20) DEFAULT NULL,
  `fromDate` date DEFAULT NULL,
  `toDate` date DEFAULT NULL,
  `remarks` text,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_hostel_room_resource_idx` (`resourceId`),
  KEY `fk_hostel_room_floor_idx` (`floorId`),
  KEY `fk_hostel_room_type_idx` (`roomTypeId`),
  KEY `fk_hostel_room_restrictions_idx` (`restrictionTypeId`),
  KEY `fk_hostel_room_status_changes_reason_idx` (`statusChnageReasonId`),
  KEY `fk_hostel_room_updateby_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_hostel_room_floor` FOREIGN KEY (`floorId`) REFERENCES `hostel_floor` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_hostel_room_resource` FOREIGN KEY (`resourceId`) REFERENCES `resources` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_hostel_room_restrictions` FOREIGN KEY (`restrictionTypeId`) REFERENCES `hostel_restriction_type` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_hostel_room_status_changes_reason` FOREIGN KEY (`statusChnageReasonId`) REFERENCES `hostel_status_change_reason` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_hostel_room_type` FOREIGN KEY (`roomTypeId`) REFERENCES `hostel_room_type` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_hostel_room_updateby` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `hostel_bed` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `roomId` bigint(20) NOT NULL,
  `bedNumber` varchar(60) DEFAULT NULL,
  `bedDeatails` text,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_hostel_bed_room_idx` (`roomId`),
  KEY `fk_hostel_bed_updateby_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_hostel_bed_room` FOREIGN KEY (`roomId`) REFERENCES `hostel_room` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_hostel_bed_updateby` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `hostel_available_history_details` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `roomId` bigint(20) NOT NULL,
  `roomStatus` varchar(45) DEFAULT NULL,
  `statusChnageReasonId` bigint(20) DEFAULT NULL,
  `fromDate` date DEFAULT NULL,
  `toDate` date DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_hostel_available_histroy_room_idx` (`roomId`),
  KEY `fk_hostel_available_histroy_sch_idx` (`statusChnageReasonId`),
  KEY `fk_hostel_available_history_details_updateby_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_hostel_available_history_details_updateby` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_hostel_available_histroy_room` FOREIGN KEY (`roomId`) REFERENCES `hostel_room` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_hostel_available_histroy_sch` FOREIGN KEY (`statusChnageReasonId`) REFERENCES `hostel_status_change_reason` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `hostel_room_allotment` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `roomId` bigint(20) NOT NULL,
  `studentId` bigint(20) DEFAULT NULL,
  `userId` bigint(20) DEFAULT NULL,
  `allotmentDate` date DEFAULT NULL,
  `allotmentBy` bigint(20) DEFAULT NULL,
  `createdBy` bigint(20) DEFAULT NULL,
  `allotmentStatus` varchar(45) DEFAULT NULL,
  `cancelDate` date DEFAULT NULL,
  `cancellationBy` bigint(20) DEFAULT NULL,
  `cancelReasonId` bigint(20) DEFAULT NULL,
  `cancelRemarks` text,
  `bedId` bigint(20) DEFAULT NULL,
  `checkInDate` date DEFAULT NULL,
  `expectedCheckOutDate` date DEFAULT NULL,
  `keyHandoverTo` bigint(20) DEFAULT NULL,
  `keyHandoverBy` bigint(20) DEFAULT NULL,
  `checkOutDate` date DEFAULT NULL,
  `keyReturnedTo` bigint(20) DEFAULT NULL,
  `checkOutReasonId` bigint(20) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_hostel_room_allotment_room_idx` (`roomId`),
  KEY `fk_hostel_room_allotment_student_idx` (`studentId`),
  KEY `fk_hostel_room_allotment_users_idx` (`userId`),
  KEY `fk_hostel_room_allotment_allotmentby_idx` (`allotmentBy`),
  KEY `fk_hostel_room_allotment_createdby_idx` (`createdBy`),
  KEY `fk_hostel_room_allotment_cancelby_idx` (`cancellationBy`),
  KEY `fk_hostel_room_allotment_cancelreason_idx` (`cancelReasonId`),
  KEY `fk_hostel_room_allotment_bed_idx` (`bedId`),
  KEY `fk_hostel_room_allotment_keyhandoverTo_idx` (`keyHandoverTo`),
  KEY `fk_hostel_room_allotment_keyhandoverBy_idx` (`keyHandoverBy`),
  KEY `fk_hostel_room_allotment_keyreturnto_idx` (`keyReturnedTo`),
  KEY `fk_hostel_room_allotment_updateby_idx` (`lastUpdatedBy`),
  KEY `fk_hostel_room_allotment_checkoutreason_idx` (`checkOutReasonId`),
  CONSTRAINT `fk_hostel_room_allotment_allotmentby` FOREIGN KEY (`allotmentBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_hostel_room_allotment_bed` FOREIGN KEY (`bedId`) REFERENCES `hostel_bed` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_hostel_room_allotment_cancelby` FOREIGN KEY (`cancellationBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_hostel_room_allotment_cancelreason` FOREIGN KEY (`cancelReasonId`) REFERENCES `hostel_cancellation_reason` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_hostel_room_allotment_checkoutreason` FOREIGN KEY (`checkOutReasonId`) REFERENCES `hostel_checkout_reason` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_hostel_room_allotment_createdby` FOREIGN KEY (`createdBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_hostel_room_allotment_keyhandoverBy` FOREIGN KEY (`keyHandoverBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_hostel_room_allotment_keyhandoverTo` FOREIGN KEY (`keyHandoverTo`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_hostel_room_allotment_keyreturnto` FOREIGN KEY (`keyReturnedTo`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_hostel_room_allotment_room` FOREIGN KEY (`roomId`) REFERENCES `hostel_room` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_hostel_room_allotment_student` FOREIGN KEY (`studentId`) REFERENCES `students` (`userId`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_hostel_room_allotment_updateby` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_hostel_room_allotment_users` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
