
CREATE TABLE `exam_document_name` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `itemCode` varchar(255) NOT NULL,
  `itemValue` varchar(255) NOT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_exam_document_name_1` (`lastUpdatedBy`),
  CONSTRAINT `fk_exam_document_name_1` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `examination_documents` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `examDocumentNameId` bigint(20) NOT NULL,
  `description` varchar(255) NOT NULL,
  `uploadDate` date NOT NULL,
  `documentPath` varchar(255) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `version` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_examination_documents_1` (`examDocumentNameId`),
  KEY `fk_examination_documents_2` (`lastUpdatedBy`),
  CONSTRAINT `fk_examination_documents_1` FOREIGN KEY (`examDocumentNameId`) REFERENCES `exam_document_name` (`id`),
  CONSTRAINT `fk_examination_documents_2` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE `exam_document_cd` (
  `id` bigint(255) NOT NULL AUTO_INCREMENT,
  `cf1` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `cf2` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `cf3` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `cf4` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `cf5` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `cf6` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `cf7` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `cf8` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `cf9` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `cf10` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `examDocumentId` bigint(20) DEFAULT NULL,
  `lastUpdate` timestamp NULL DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `cf11` bigint(20) DEFAULT NULL,
  `cf12` bigint(20) DEFAULT NULL,
  `cf13` bigint(20) DEFAULT NULL,
  `cf14` timestamp NULL DEFAULT NULL,
  `cf15` timestamp NULL DEFAULT NULL,
  `cf16` bit(1) DEFAULT NULL,
  `cf17` bit(1) DEFAULT NULL,
  `cf18` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `cf19` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `version` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `examDocumentId` (`examDocumentId`),
  KEY `lastUpdatedBy` (`lastUpdatedBy`),
  CONSTRAINT `exam_document_cd_ibfk_1` FOREIGN KEY (`examDocumentId`) REFERENCES `examination_documents` (`id`),
  CONSTRAINT `exam_document_cd_ibfk_2` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);

INSERT INTO `standard_master` (`tableName`, `masterName`, `moduleName`, `filterCode`, `whetherChild`, `whetherParent`, `lastUpdatedBy`,`lastUpdate`) 
VALUES ('exam_document_name', 'EXAM_DOCUMENT_NAME', 'Examinations', 'COMMON_MASTER', 0, 0, '1',@currentTimeStamp);

SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
INSERT INTO `standard_master_items` (`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`,`lastUpdate`) 
VALUES ('code', 'ITEM_CODE', @standardMasterMaxId, 'Varchar', '1', 0, 0, 0, 1, '1',@currentTimeStamp);

INSERT INTO `standard_master_items` (`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`,`lastUpdate`) 
VALUES ('value', 'ITEM_VALUE', @standardMasterMaxId, 'Varchar', '1', 0, 0, 0, 1, '1',@currentTimeStamp);

INSERT INTO `custom_table_configs` (`displayName`,`tableName`,`customTableName`) VALUES ('Examination Documents','examination_documents','exam_document_cd');

ALTER TABLE `examination_documents` 
DROP FOREIGN KEY `fk_examination_documents_2`;
ALTER TABLE `examination_documents` 
CHANGE COLUMN `description` `description` VARCHAR(255) NULL DEFAULT NULL ,
CHANGE COLUMN `uploadDate` `uploadDate` DATE NULL DEFAULT NULL ,
CHANGE COLUMN `lastUpdatedBy` `lastUpdatedBy` BIGINT(20) NOT NULL ;
ALTER TABLE `examination_documents` 
ADD CONSTRAINT `fk_examination_documents_2`
  FOREIGN KEY (`lastUpdatedBy`)
  REFERENCES `users` (`id`);

  ALTER TABLE `exam_document_name` 
CHANGE COLUMN `itemCode` `itemCode` VARCHAR(255) NULL DEFAULT NULL ,
CHANGE COLUMN `itemValue` `itemValue` VARCHAR(255) NULL DEFAULT NULL ;

