-- Student Other Information
CREATE TABLE `student_other_information` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `studentId` bigint(20) NOT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE INDEX `studentId_UNIQUE_key` (`studentId` ASC),
  KEY `fk_student_other_information_studentId` (`studentId`),
  KEY `fk_student_other_information_lastUpdatedBy` (`lastUpdatedBy`),
  CONSTRAINT `fk_student_other_information_studentId` FOREIGN KEY (`studentId`) REFERENCES `students` (`userId`),
  CONSTRAINT `fk_student_other_information_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Student Other Information Custom Data
CREATE TABLE `student_other_information_cd` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `studentOtherInfoId` bigint(20) DEFAULT NULL,
  `cf1` varchar(255) DEFAULT NULL,
  `cf2` varchar(255) DEFAULT NULL,
  `cf3` varchar(255) DEFAULT NULL,
  `cf4` varchar(255) DEFAULT NULL,
  `cf5` varchar(255) DEFAULT NULL,
  `cf6` varchar(255) DEFAULT NULL,
  `cf7` varchar(255) DEFAULT NULL,
  `cf8` varchar(255) DEFAULT NULL,
  `cf9` varchar(255) DEFAULT NULL,
  `cf10` varchar(255) DEFAULT NULL,
  `cf11` bigint(20) DEFAULT NULL,
  `cf12` bigint(20) DEFAULT NULL,
  `cf13` bigint(20) DEFAULT NULL,
  `cf14` date DEFAULT NULL,
  `cf15` date DEFAULT NULL,
  `cf16` tinyint(1) DEFAULT NULL,
  `cf17` tinyint(1) DEFAULT NULL,
  `cf18` varchar(255) DEFAULT NULL,
  `cf19` varchar(255) DEFAULT NULL,
  `version` bigint(20) NOT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `lastUpdate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `fk_student_other_information_cd_id` (`studentOtherInfoId`),
  KEY `fk_student_other_information_cd_users` (`lastUpdatedBy`),
  CONSTRAINT `fk_student_other_information_cd_id` FOREIGN KEY (`studentOtherInfoId`) REFERENCES `student_other_information` (`id`),
  CONSTRAINT `fk_student_other_information_cd_users` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


-- Employee Other Information
CREATE TABLE `staff_other_information` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `staffId` bigint(20) NOT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE INDEX `staffId_UNIQUE_key` (`staffId` ASC),
  KEY `fk_staff_other_information_staffId` (`staffId`),
  KEY `fk_staff_other_information_lastUpdatedBy` (`lastUpdatedBy`),
  CONSTRAINT `fk_staff_other_information_staffId` FOREIGN KEY (`staffId`) REFERENCES `staffs` (`userId`),
  CONSTRAINT `fk_staff_other_information_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Employee Other Information Custom Data
CREATE TABLE `staff_other_information_cd` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `staffOtherInfoId` bigint(20) DEFAULT NULL,
  `cf1` varchar(255) DEFAULT NULL,
  `cf2` varchar(255) DEFAULT NULL,
  `cf3` varchar(255) DEFAULT NULL,
  `cf4` varchar(255) DEFAULT NULL,
  `cf5` varchar(255) DEFAULT NULL,
  `cf6` varchar(255) DEFAULT NULL,
  `cf7` varchar(255) DEFAULT NULL,
  `cf8` varchar(255) DEFAULT NULL,
  `cf9` varchar(255) DEFAULT NULL,
  `cf10` varchar(255) DEFAULT NULL,
  `cf11` bigint(20) DEFAULT NULL,
  `cf12` bigint(20) DEFAULT NULL,
  `cf13` bigint(20) DEFAULT NULL,
  `cf14` date DEFAULT NULL,
  `cf15` date DEFAULT NULL,
  `cf16` tinyint(1) DEFAULT NULL,
  `cf17` tinyint(1) DEFAULT NULL,
  `cf18` varchar(255) DEFAULT NULL,
  `cf19` varchar(255) DEFAULT NULL,
  `version` bigint(20) NOT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `lastUpdate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `fk_staff_other_information_cd_id` (`staffOtherInfoId`),
  KEY `fk_staff_other_information_cd_users` (`lastUpdatedBy`),
  CONSTRAINT `fk_staff_other_information_cd_id` FOREIGN KEY (`staffOtherInfoId`) REFERENCES `staff_other_information` (`id`),
  CONSTRAINT `fk_staff_other_information_cd_users` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
