CREATE TABLE `hr_employee_eligible_leave` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `userId` bigint(20) DEFAULT NULL,
  `leaveTypeId` bigint(20) DEFAULT NULL,
  `eligibilityLeaveTypeId` bigint(20) DEFAULT NULL,
  `leaveCount` double(10,2) DEFAULT NULL,
  `creditDate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_hr_employee_eligible_leave_1_idx` (`userId`),
  KEY `fk_hr_employee_eligible_leave_2_idx` (`leaveTypeId`),
  KEY `fk_hr_employee_eligible_leave_3_idx` (`eligibilityLeaveTypeId`),
  KEY `fk_hr_employee_eligible_leave_4_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_hr_employee_eligible_leave_1` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_hr_employee_eligible_leave_2` FOREIGN KEY (`leaveTypeId`) REFERENCES `hr_leave_type` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_hr_employee_eligible_leave_3` FOREIGN KEY (`eligibilityLeaveTypeId`) REFERENCES `hr_eligibility_leave_type` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_hr_employee_eligible_leave_4` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;