CREATE TABLE `course_category` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `categoryName` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Refusers_course_category` (`lastUpdatedBy`),
  CONSTRAINT `Refusers_course_category` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;


SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
INSERT INTO `standard_master` (`id`,`childMaster`,`tableName`,`masterName`,`moduleName`,`filterCode`,`whetherChild`,`whetherParent`,`droolsAgenda`,`lastUpdatedBy`,`lastUpdate`) VALUES (@standardMasterMaxId + 1, NULL,'course_category','COURSE_CATEGORY','Program & Courses','COMMON_MASTER',0,0,NULL,1,'2016-11-07 10:54:58');

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO `standard_master_items` (`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) VALUES (@ItemsMaxId +1, 'categoryName', 'COURSE_CATEGORY_NAME', @standardMasterMaxId + 1, 'Varchar', 1, 0, 0, 0, 1, '2016-11-07 12:35:53');

ALTER TABLE `courses` 
ADD COLUMN `courseCategoryId` BIGINT(20) NULL AFTER `subDepartmentId`,
ADD INDEX `fk_courseCategoryId_idx` (`courseCategoryId` ASC);
ALTER TABLE `courses` 
ADD CONSTRAINT `fk_courseCategoryId`
  FOREIGN KEY (`courseCategoryId`)
  REFERENCES `course_category` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;