/********SG Visitor Category******/
CREATE TABLE `sg_visitor_category` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `itemCode` varchar(255) NOT NULL,
  `itemValue` varchar(255) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `itemCode_UNIQUE` (`itemCode`),
  UNIQUE KEY `itemValue_UNIQUE` (`itemValue`),
  KEY `fk_sg_visitor_category_updateby` (`lastUpdatedBy`),
  CONSTRAINT `fk_sg_visitor_category_updateby` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
INSERT INTO `standard_master`(`id`,`childMaster`,`tableName`,`masterName`,`moduleName`,`filterCode`,`whetherChild`,`whetherParent`, `droolsAgenda`,`lastUpdatedBy`,`lastUpdate`) 
VALUES (@standardMasterMaxId+1, NULL,'sg_visitor_category','SG_VISITOR_CATEGORY','Tools & Services','COMMON_MASTER',0,0,NULL,1,SYSDATE());

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'code', 'ITEM_CODE', @standardMasterMaxId+1, 'varchar', '1', 0, 0, 0, 0, '1', SYSDATE());

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);


/***** SG Visitor Card*********/
CREATE TABLE `sg_visitor_card` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `itemCode` varchar(255) NOT NULL,
  `itemValue` varchar(255) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `itemCode_UNIQUE` (`itemCode`),
  UNIQUE KEY `itemValue_UNIQUE` (`itemValue`),
  KEY `fk_sg_visitor_card_updateby` (`lastUpdatedBy`),
  CONSTRAINT `fk_sg_visitor_card_updateby` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
INSERT INTO `standard_master`(`id`,`childMaster`,`tableName`,`masterName`,`moduleName`,`filterCode`,`whetherChild`,`whetherParent`, `droolsAgenda`,`lastUpdatedBy`,`lastUpdate`) 
VALUES (@standardMasterMaxId+1, NULL,'sg_visitor_card','SG_VISITOR_CARD','Tools & Services','COMMON_MASTER',0,0,NULL,1,SYSDATE());

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'code', 'ITEM_CODE', @standardMasterMaxId+1, 'varchar', '1', 0, 0, 0, 0, '1', SYSDATE());

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'value', 'ITEM_VALUE', @standardMasterMaxId+1, 'varchar', '2', 0, 0, 0, 0, '1', SYSDATE());



/*********Visitor Category********/
insert into sg_visitor_category values(1,'Parent/Guardian','Parent/Guardian','2017-02-17 12:00:00',1);


/******SG Appointment***********/
CREATE TABLE `sg_appointment` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `visitorCategoryId` bigint(20) NOT NULL,
  `bookingId` varchar(255) NOT NULL,
  `appointeeName` varchar(255) NOT NULL,
  `appointeeContactNo` varchar(12) DEFAULT NULL,
  `appointeeEmailId` varchar(45) DEFAULT NULL,
  `bookingDate` date NOT NULL,
  `appointmentDate` date NOT NULL,
  `personToMeet` varchar(255) NOT NULL,
  `visitTime` time NOT NULL,
  `expectedOutTime` time DEFAULT NULL,
  `reasonToVisit` text,
  `entryBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_sg_appointment_lastUpdatedBy` (`lastUpdatedBy`),
  KEY `fk_sg_appointment_entryBy` (`entryBy`),
  KEY `fk_sg_appointment_visitorCategoryId` (`visitorCategoryId`),
  CONSTRAINT `fk_sg_appointment_entryBy` FOREIGN KEY (`entryBy`) REFERENCES `users` (`id`),
  CONSTRAINT `fk_sg_appointment_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`),
  CONSTRAINT `fk_sg_appointment_visitorCategoryId` FOREIGN KEY (`visitorCategoryId`) REFERENCES `sg_visitor_category` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*******SG Manage Visitors**********/
CREATE TABLE `sg_manage_visitors` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `isAppointment` bit(1) DEFAULT b'0',
  `visitorCategoryId` bigint(20) NOT NULL,
  `visitorNo` varchar(45) NOT NULL,
  `visitorCardNo` varchar(45) NOT NULL,
  `personImagePath` varchar(45) DEFAULT NULL,
  `visitorName` varchar(45) DEFAULT NULL,
  `visitorContactNo` varchar(12) DEFAULT NULL,
  `visitorEmailId` varchar(45) DEFAULT NULL,
  `visitorVehicleNo` varchar(20) DEFAULT NULL,
  `visitorOrganization` varchar(45) DEFAULT NULL,
  `visitorPlace` varchar(45) DEFAULT NULL,
  `bookingId` varchar(45) DEFAULT NULL,
  `visitorAddress` varchar(255) DEFAULT NULL,
  `inTime` time NOT NULL,
  `outTime` time DEFAULT NULL,
  `reasonToVisit` varchar(255) DEFAULT NULL,
  `personToMeet` varchar(45) NOT NULL,
  `personContactNo` varchar(45) DEFAULT NULL,
  `meetingDate` date DEFAULT NULL,
  `entryBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `isGoingOutWithStudent` bit(1) NOT NULL DEFAULT b'0',
  `isMultiDayPass` bit(1) DEFAULT b'0',
  `tillDate` date DEFAULT NULL,
  `isParentOrGardian` bit(1) NOT NULL DEFAULT b'0',
  PRIMARY KEY (`id`),
  KEY `fk_sg_manage_visitors_visitorCategoryId` (`visitorCategoryId`),
  KEY `fk_sg_manage_visitors_entryBy` (`entryBy`),
  KEY `fk_sg_manage_visitors_lastUpdatedBy` (`lastUpdatedBy`),
  CONSTRAINT `fk_sg_manage_visitors_entryBy` FOREIGN KEY (`entryBy`) REFERENCES `users` (`id`),
  CONSTRAINT `fk_sg_manage_visitors_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`),
  CONSTRAINT `fk_sg_manage_visitors_visitorCategoryId` FOREIGN KEY (`visitorCategoryId`) REFERENCES `sg_visitor_category` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
