
CREATE TABLE `fd_management_items` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `entryType` varchar(45) NOT NULL,
  `itemCategoryId` bigint(20) NOT NULL,
  `inwardNo` varchar(255) NOT NULL,
  `senderName` varchar(55) DEFAULT NULL,
  `senderContactNo` varchar(15) DEFAULT NULL,
  `receiverId` bigint(20) DEFAULT NULL,
  `receiverContactNo` varchar(15) DEFAULT NULL,
  `entryBy` bigint(20) DEFAULT NULL,
  `serviceProviderId` bigint(20) DEFAULT NULL,
  `noOfPackets` int(11) DEFAULT NULL,
  `deliveryDate` date DEFAULT NULL,
  `isBillReceived` bit(1) DEFAULT NULL,
  `billNo` varchar(45) DEFAULT NULL,
  `billAmount` double DEFAULT NULL,
  `remark` text,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_item_category_id_idx` (`itemCategoryId`),
  KEY `fk_service_provider_id_idx` (`serviceProviderId`),
  KEY `fk_receiver_id_idx` (`receiverId`),
  KEY `fk_entryBy_id_idx` (`entryBy`),
  KEY `fk_lastUpdateBy_id_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_entryBy_id` FOREIGN KEY (`entryBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_item_category_id` FOREIGN KEY (`itemCategoryId`) REFERENCES `invt_type_master` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_lastUpdateBy_id` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_receiver_id` FOREIGN KEY (`receiverId`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_service_provider_id` FOREIGN KEY (`serviceProviderId`) REFERENCES `invt_service_provider_master` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
	
	
CREATE TABLE `fd_item_details` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `itemId` BIGINT(20) NOT NULL,
  `docketNo` VARCHAR(255) NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_item_id_idx` (`itemId` ASC),
  INDEX `fk_lastUpdatedBy_id_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_item_id`
    FOREIGN KEY (`itemId`)
    REFERENCES `fd_management_items` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_lastUpdatedBy_id`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);
	
	
	
CREATE TABLE `fd_item_document` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `itemId` BIGINT(20) NOT NULL,
  `documentId` BIGINT(20) NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_item_id1_idx` (`itemId` ASC),
  INDEX `fk_document_id_idx` (`documentId` ASC),
  INDEX `fk_lastUpdatedBy_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_item_id1`
    FOREIGN KEY (`itemId`)
    REFERENCES `fd_management_items` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_document_id1`
    FOREIGN KEY (`documentId`)
    REFERENCES `documents` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_lastUpdatedBy_id1`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);
