INSERT INTO `dashlets` (`displayCode`, `xtype`, `lastUpdate`, `lastUpdatedBy`) VALUES ('STUDENT_MYDOCUMENTS_DASHLET', 'studentmydocumentsdashlet', '2017-04-28 12:50:00', '1');

set @dashletId=(select id from dashlets where displayCode='STUDENT_MYDOCUMENTS_DASHLET');
INSERT INTO `dashlets_portals` (`dashletId`, `portalId`, `lastUpdate`, `lastUpdatedBy`) VALUES (@dashletId, '3', '2017-04-28 12:50:00', '1');

INSERT INTO `role_portal_dashlets` (`roleId`, `portalId`, `dashletId`, `lastUpdate`, `lastUpdatedBy`) VALUES ('1', '3', @dashletId, '2017-04-28 12:50:00', '1');

DROP function IF EXISTS `func_inc_var_session`;

DELIMITER $$
CREATE FUNCTION `func_inc_var_session`() RETURNS int(11)
    NO SQL
begin
      SET @var := IFNULL(@var,0) + 1;
      return @var;
     end$$

DELIMITER ;

CREATE 
 OR REPLACE VIEW `student_publish_data` AS
    select 
        func_inc_var_session() AS `Id`,
        `eval_group_hall_ticket`.`admissionId` AS `admissionId`,
        `admission`.`studentId` AS `studentId`,
        `eval_group_hall_ticket`.`reportType` AS `reportType`,
        `eval_group_hall_ticket`.`hallTicketPath` AS `documentPath`,
        `eval_group_hall_ticket`.`hallTicketNumber` AS `documentName`,
         DATE_FORMAT(`eval_group_hall_ticket`.`lastUpdate`,'%Y-%m-%d') AS `publishDate`
    from
        (`eval_group_hall_ticket`
		left join `admission` ON ((`eval_group_hall_ticket`.`admissionId` = `admission`.`id`)))
    where
        ((`eval_group_hall_ticket`.`isPublishHallTicket` = 1)
            and (`eval_group_hall_ticket`.`reportType` = 'HALL_TICKET')) 
    union select 
        func_inc_var_session() AS `Id`,
        `marksheet_job_details`.`admissionId` AS `admissionId`,
        `admission`.`studentId` AS `studentId`,
        'MARKSHEET' AS `reportType`,
        `marksheet_job_details`.`marksheetPath` AS `documentPath`,
        `marksheet_job_sub_level`.`marksheetJobSubLevelName` AS `documentName`,
        `marksheet_job_sub_level`.`publishDate` AS `publishDate`
    from
        ((`marksheet_job_details`
        left join `marksheet_job_sub_level` ON ((`marksheet_job_details`.`marksheetJobSubLevelId` = `marksheet_job_sub_level`.`id`)))
        left join `admission` ON ((`marksheet_job_details`.`admissionId` = `admission`.`id`)))
    where
        (`marksheet_job_details`.`isPublishMarksheet` = 1);

