-- mobile integration notification table
CREATE TABLE IF NOT EXISTS `mobile_notification` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `notificationId` bigint(20) NOT NULL,
  `mobileNotificationId` varchar(255) DEFAULT NULL,
  `groupId` bigint(20) DEFAULT NULL,
  `mobileUserId` bigint(20) DEFAULT NULL,
  `instituteId` varchar(255) DEFAULT NULL,
  `apiAction` varchar(20) DEFAULT NULL,
  `status` varchar(20) DEFAULT NULL,
  `errorMessage` TEXT DEFAULT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_mobile_notification_updatedby` (`lastUpdatedBy`),
  KEY `fk_mobile_notification_groupId` (`groupId`),
  KEY `fk_mobile_notification_mobileUserId` (`mobileUserId`),
  CONSTRAINT `fk_mobile_notification_groupId` FOREIGN KEY (`groupId`) REFERENCES `mobile_group` (`id`),
  CONSTRAINT `fk_mobile_notification_mobileUserId` FOREIGN KEY (`mobileUserId`) REFERENCES `mobile_user` (`id`),
  CONSTRAINT `fk_mobile_notification_updatedby` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;