CREATE TABLE `examination_revaluation` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `revaluationCode` varchar(30) DEFAULT NULL,
  `revaluationName` varchar(90) DEFAULT NULL,
  `revaluationFor` varchar(45) DEFAULT NULL,
  `maxRevaluationToApply` int(11) DEFAULT NULL,
  `validTill` date DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `examination_revaluation_unique_record1` (`revaluationCode`),
  KEY `examination_revaluation_lastUpdatedBy` (`lastUpdatedBy`),
  CONSTRAINT `examination_revaluation_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `examination_revaluation_rules` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `examRevaluationId` bigint(20) DEFAULT NULL,
  `revaluationType` varchar(30) DEFAULT NULL,
  `feePlanId` bigint(20) DEFAULT NULL,
  `feePlanRuleId` bigint(20) DEFAULT NULL,
  `feeAmount` double DEFAULT NULL,
  `noOfRevaluers` int(11) DEFAULT NULL,
  `maxRevaluationToApply` int(11) DEFAULT NULL,
  `ruleApplicable` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `exam_reval_rules_unique_record` (`examRevaluationId`,`revaluationType`),
  KEY `examination_revaluation_rules_examRevaluationId` (`examRevaluationId`),
  KEY `examination_revaluation_rules_feePlanId` (`feePlanId`),
  KEY `examination_revaluation_rules_feePlanRuleId` (`feePlanRuleId`),
  KEY `examination_revaluation_rules_lastUpdatedBy` (`lastUpdatedBy`),
  CONSTRAINT `examination_revaluation_rules_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `examination_revaluation_rules_examRevaluationId` FOREIGN KEY (`examRevaluationId`) REFERENCES `examination_revaluation` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `examination_revaluation_rules_feePlanId` FOREIGN KEY (`feePlanId`) REFERENCES `fee_plan` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `examination_revaluation_rules_feePlanRuleId` FOREIGN KEY (`feePlanRuleId`) REFERENCES `fee_plan_rules` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `exam_revaluation_rule_mapping` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `examRevalRuleId` bigint(20) DEFAULT NULL,
  `periodId` bigint(20) DEFAULT NULL,
  `startDate` date DEFAULT NULL,
  `endDate` date DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `exam_reval_rule_mapping_unique_record` (`examRevalRuleId`,`periodId`),
  KEY `exam_revaluation_rule_mapping_examRevalRuleId` (`examRevalRuleId`),
  KEY `exam_revaluation_rule_mapping_periodId` (`periodId`),
  KEY `exam_revaluation_rule_mapping_lastUpdatedBy` (`lastUpdatedBy`),
  CONSTRAINT `exam_revaluation_rule_mapping_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `exam_revaluation_rule_mapping_examRevalRuleId` FOREIGN KEY (`examRevalRuleId`) REFERENCES `examination_revaluation_rules` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `exam_revaluation_rule_mapping_periodId` FOREIGN KEY (`periodId`) REFERENCES `prog_batch_period_config` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE `examination_student_revaluation` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `examRevalRuleMappingId` bigint(20) DEFAULT NULL,
  `admissionId` bigint(20) DEFAULT NULL,
  `courseVariantId` bigint(20) DEFAULT NULL,
  `periodId` bigint(20) DEFAULT NULL,
  `eventId` bigint(20) DEFAULT NULL,
  `revaluationType` varchar(30) DEFAULT NULL,
  `previousMarks` double DEFAULT NULL,
  `revaluerMarks` double DEFAULT NULL,
  `previousGrade` varchar(60) DEFAULT NULL,
  `previousGradePoint` double DEFAULT NULL,
  `revaluerGrade` varchar(60) DEFAULT NULL,
  `revaluerGradePoint` double DEFAULT NULL,
  `dateOfRevaluation` date DEFAULT NULL,
  `appliedDate` date DEFAULT NULL,
  `feeAmount` double DEFAULT NULL,
  `previousResultStatus` varchar(60) DEFAULT NULL,
  `revaluationResultStatus` varchar(60) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `exam_student_reval_unique_record` (`examRevalRuleMappingId`,`admissionId`,`courseVariantId`,`eventId`,`periodId`),
  KEY `examination_student_revaluation_examRevalRuleMappingId` (`examRevalRuleMappingId`),
  KEY `examination_student_revaluation_admissionId` (`admissionId`),
  KEY `examination_student_revaluation_courseVariantId` (`courseVariantId`),
  KEY `examination_student_revaluation_periodId` (`periodId`),
  KEY `examination_student_revaluation_eventId` (`eventId`),
  KEY `examination_student_revaluation_lastUpdatedBy` (`lastUpdatedBy`),
  CONSTRAINT `examination_student_revaluation_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `examination_student_revaluation_examRevalRuleMappingId` FOREIGN KEY (`examRevalRuleMappingId`) REFERENCES `exam_revaluation_rule_mapping` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `examination_student_revaluation_admissionId` FOREIGN KEY (`admissionId`) REFERENCES `admission` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `examination_student_revaluation_courseVariantId` FOREIGN KEY (`courseVariantId`) REFERENCES `course_variants` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `examination_student_revaluation_periodId` FOREIGN KEY (`periodId`) REFERENCES `prog_batch_period_config` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `examination_student_revaluation_eventId` FOREIGN KEY (`eventId`) REFERENCES `eval_seq_detail` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `exam_student_revaluation_fees` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `examRevalRuleMappingId` bigint(20) DEFAULT NULL,
  `admissionId` bigint(20) DEFAULT NULL,
  `totalFees` double DEFAULT NULL,
  `feesCalculationDate` date DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `exam_student_reval_fees_unique_record` (`examRevalRuleMappingId`,`admissionId`),
  KEY `exam_student_revaluation_fees_examRevalRuleMappingId` (`examRevalRuleMappingId`),
  KEY `exam_student_revaluation_fees_admissionId` (`admissionId`),
  KEY `exam_student_revaluation_fees_lastUpdatedBy` (`lastUpdatedBy`),
  CONSTRAINT `exam_student_revaluation_fees_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `exam_student_revaluation_fees_examRevalRuleMappingId` FOREIGN KEY (`examRevalRuleMappingId`) REFERENCES `exam_revaluation_rule_mapping` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `exam_student_revaluation_fees_admissionId` FOREIGN KEY (`admissionId`) REFERENCES `admission` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
