CREATE TABLE `bulk_document_upload_status` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `importUtilityUploadedFileId` bigint(20) DEFAULT NULL,
  `academyLocationId` bigint(20) DEFAULT NULL,
  `userType` varchar(45) DEFAULT NULL,
  `documentTypeId` bigint(20) DEFAULT NULL,
  `staffId` bigint(20) DEFAULT NULL,
  `studentId` bigint(20) DEFAULT NULL,
  `applicationId` bigint(20) DEFAULT NULL,
  `fileName` varchar(255) DEFAULT NULL,
  `status` varchar(45) DEFAULT NULL,
  `failureReason` text,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_bulk_document_upload_status_lastUpdatedBy_idx` (`lastUpdatedBy`),
  KEY `fk_bulk_document_upload_status_applicationId_idx` (`academyLocationId`),
  KEY `fk_bulk_document_upload_status_studentId_idx` (`studentId`),
  KEY `fk_bulk_document_upload_status_staffId_idx` (`staffId`),
  KEY `fk_bulk_document_upload_status_documentTypeId_idx` (`documentTypeId`),
  CONSTRAINT `fk_bulk_document_upload_status_academyLocationId` FOREIGN KEY (`academyLocationId`) REFERENCES `academy_location` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_bulk_document_upload_status_applicationId` FOREIGN KEY (`academyLocationId`) REFERENCES `application` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_bulk_document_upload_status_documentTypeId` FOREIGN KEY (`documentTypeId`) REFERENCES `document_types` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_bulk_document_upload_status_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_bulk_document_upload_status_staffId` FOREIGN KEY (`staffId`) REFERENCES `staffs` (`userId`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_bulk_document_upload_status_studentId` FOREIGN KEY (`studentId`) REFERENCES `students` (`userId`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;