DROP procedure IF EXISTS `sp_rpt_sales_admission_summary`;

DELIMITER $$
CREATE PROCEDURE `sp_rpt_sales_admission_summary`(vacademyLocation text, varIntakeYear varchar(10))
BEGIN
	
	declare vIntakeYrPrev varchar(10);

	truncate table tbl_rpt_sales_admission_summary;
/*	drop table if exists tbl_rpt_sales_admission_summary;
	create table tbl_rpt_sales_admission_summary
	(orgName varchar(255), academyId bigint(20), academyName varchar(100)
	, currIntakeYr int(10), currIntakeYrId bigint(20), currLeads int, currAp int
	, currAprvd_ap int, currEnrol int, prevIntakeYr int(10), prevIntakeYrId bigint(20)
	, prevLeads int, prevAp int, prevAprvdAp int, prevEnrol int

	, perc_leads_ap double(7,2), perc_leads_aprvd_ap double(7,2), perc_leads_enrol double(7,2)
	, prev_perc_leads_ap double(7,2), prev_perc_leads_aprvd_ap double(7,2), prev_perc_leads_enrol double(7,2)

	, perc_prev_stg_ap double(7,2), perc_prev_stg_aprvd_ap double(7,2), perc_prev_stg_enrol double(7,2)
	, prev_perc_prev_stg_ap double(7,2), prev_perc_prev_stg_aprvd_ap double(7,2), prev_perc_prev_stg_enrol double(7,2)



	, abs_chng_leads int, abs_chng_ap int, abs_chng_aprvd_ap int, abs_chng_enrol int

	, abs_perc_chng_leads double(7,2), abs_perc_chng_ap double(7,2), abs_perc_chng_aprvd_ap double(7,2)
	, abs_perc_chng_enrol double(7,2)


	, currLeadsOrg int, currApOrg int, currAprvdApOrg int, currEnrolOrg int
	, prevLeadsOrg int, prevApOrg int, prevAprvdApOrg int, prevEnrolOrg int

	, org_perc_leads_ap double(7,2), org_perc_leads_aprvd_ap double(7,2), org_perc_leads_enrol double(7,2)
	, org_prev_perc_leads_ap double(7,2), org_prev_perc_leads_aprvd_ap double(7,2), org_prev_perc_leads_enrol double(7,2)

	, org_perc_prev_stg_ap double(7,2), org_perc_prev_stg_aprvd_ap double(7,2), org_perc_prev_stg_enrol double(7,2)
	, org_prev_perc_prev_stg_ap double(7,2), org_prev_perc_prev_stg_aprvd_ap double(7,2)
	, org_prev_perc_prev_stg_enrol double(7,2)

	, org_abs_chng_leads int, org_abs_chng_ap int, org_abs_chng_aprvd_ap int, org_abs_chng_enrol int
	
	, org_abs_perc_chng_leads double(7,2), org_abs_perc_chng_ap double(7,2), org_abs_perc_chng_aprvd_ap double(7,2)
	, org_abs_perc_chng_enrol double(7,2));

*/
	set sql_safe_updates = 0;

	select i1.id as iy into vIntakeYrPrev from intake_year as i1, intake_year as i2 where i1.itemValue = i2.itemValue - 1 and i2.id = varIntakeYear;

-- 	select vIntakeYrPrev;
	
	call str_to_row (vacademyLocation);

	insert into tbl_rpt_sales_admission_summary(orgName, academyId, academyName, currIntakeYr, currIntakeYrId)
	select o.orgName, al.academyId, al.academyName, i.itemValue, i.id as intakeYearId
		from organizations as o
		join academies as a on o.id = a.organizationId
		join academy_location al on al.academyId = a.id and al.academyId in (select s from tbl_str_to_row) 
		join programs p on al.id = p.academyLocationId
		join batches as b on p.id = b.programId and b.intakeYearId = varIntakeYear
		join intake_year as i on i.id = b.intakeYearId
	group by al.academyId, i.id;

	begin
		DECLARE done INTEGER DEFAULT 0;
		declare vorgName, vacademyId, vacademyName, vitemValue, vintakeYearId varchar(255);
		DEClARE cursor_prev_dat CURSOR FOR select o.orgName, al.academyId, al.academyName, i.itemValue, i.id as intakeYearId
		from  organizations as o join academies as a on o.id = a.organizationId
		join academy_location al on al.academyId = a.id and al.academyId in (select s from tbl_str_to_row) 
		join programs p on al.id = p.academyLocationId
		join batches as b on p.id = b.programId and b.intakeYearId = vIntakeYrPrev
		join intake_year as i on i.id = b.intakeYearId
	group by al.academyId, i.id;
	DECLARE CONTINUE HANDLER FOR NOT FOUND SET done = 1;
	
	OPEN cursor_prev_dat;
	prev_dat: LOOP
	FETCH cursor_prev_dat INTO vorgName, vacademyId, vacademyName, vitemValue, vintakeYearId;
	IF done = 1 THEN 
		LEAVE prev_dat;
	END IF;

		if (select count(1) from tbl_rpt_sales_admission_summary where academyId = vacademyId) > 0
			then 	
				update tbl_rpt_sales_admission_summary set prevIntakeYrId = vIntakeYrPrev;
		else
				insert into tbl_rpt_sales_admission_summary(orgName, academyId, academyName, currIntakeYrId, prevIntakeYr, prevIntakeYrId)
				values(vorgName, vacademyId, vacademyName, varIntakeYear, vitemValue, vintakeYearId);
/*				select o.orgName, al.academyId, al.academyName, i.itemValue, i.id as intakeYearId
				from organizations as o join academies as a on o.id = a.organizationId
					join academy_location al on al.academyId = a.id
					join user_academy_locations as ual on ual.academyLocationId = al.id
					join users as u on u.id = ual.userId and u.id = varUserId
					join programs p on al.id = p.academyLocationId
					join batches as b on p.id = b.programId and b.intakeYearId = (select i1.id as iy from intake_year as i1, intake_year as i2 where i1.itemValue = i2.itemValue - 1 and i2.id = varIntakeYear)
					join intake_year as i on i.id = b.intakeYearId
				group by al.academyId, i.id;
*/
update tbl_rpt_sales_admission_summary set currIntakeYr = (select itemValue from intake_year
where id = varIntakeYear) where currIntakeYr is null;
update tbl_rpt_sales_admission_summary set prevIntakeYr = (select itemValue from intake_year 
where id = vIntakeYrPrev) where prevIntakeYr is null;

		end if;
	
	END LOOP prev_dat;
	
	CLOSE cursor_prev_dat;
	end;

/**************************** current leads *******************************/
update tbl_rpt_sales_admission_summary as tbl, 
(select count(distinct e.code) as enq_cnt, b.intakeYearId, al.academyId
from enquiry as e join academy_location as al on e.academyLocationId = al.id
	join programs p on al.id = p.academyLocationId and al.academyId in (select s from tbl_str_to_row) 
  	join batches as b on p.id = b.programId and b.intakeYearId = varIntakeYear
group by al.academyId, b.intakeYearId) as t
set tbl.currLeads = t.enq_cnt
where tbl.academyId = t.academyId and tbl.currIntakeYrId = t.intakeYearId;

/********************** previous year leads *******************************/
update tbl_rpt_sales_admission_summary as tbl, 
(select count(distinct e.code) as enq_cnt, b.intakeYearId, al.academyId
from enquiry as e join academy_location as al on e.academyLocationId = al.id
	join programs p on al.id = p.academyLocationId and al.academyId in (select s from tbl_str_to_row) 
  	join batches as b on p.id = b.programId and b.intakeYearId = vIntakeYrPrev
group by al.academyId, b.intakeYearId) as t
set tbl.prevLeads = t.enq_cnt
where tbl.academyId = t.academyId and tbl.prevIntakeYrId = t.intakeYearId;

/**************************** current application *******************************/
update tbl_rpt_sales_admission_summary as tbl, 
(Select al.academyId as aId, count(distinct a.code) as tot_ap, b.intakeYearId
		from application a join application_program ap on a.id = ap.applicationId
		join programs p on p.id = ap.programId
		join academy_location al on al.id = ap.academyLocationId and al.academyId in (select s from tbl_str_to_row) 
		join prog_batch_seat_config absc on ap.progBatchSeatConfigId = absc.id
		join batches b on b.id = absc.programBatchId and b.intakeYearId = varIntakeYear
	where a.currentStatus in ('SUBMITTED','APPROVED','ADMISSION GRANTED')
		group by al.academyId, b.intakeYearId) as t
set tbl.currAp = t.tot_ap
where tbl.academyId = t.aId and tbl.currIntakeYrId = t.intakeYearId;

/********************** previous year application *******************************/
update tbl_rpt_sales_admission_summary as tbl, 
(Select al.academyId as aId, count(distinct a.code) as tot_ap, b.intakeYearId
		from application a join application_program ap on a.id = ap.applicationId
		join programs p on p.id = ap.programId
		join academy_location al on al.id = ap.academyLocationId and al.academyId in (select s from tbl_str_to_row) 
		join prog_batch_seat_config absc on ap.progBatchSeatConfigId = absc.id
		join batches b on b.id = absc.programBatchId and b.intakeYearId = vIntakeYrPrev
	where a.currentStatus in ('SUBMITTED','APPROVED','ADMISSION GRANTED')
		group by al.academyId, b.intakeYearId) as t
set tbl.prevAp = t.tot_ap
where tbl.academyId = t.aId and tbl.prevIntakeYrId = t.intakeYearId;

/********************* current approved application ***************************/
update tbl_rpt_sales_admission_summary as tbl, 
(Select al.academyId as aId, count(distinct a.code) as tot_aprvd_Ap, b.intakeYearId
		from application a join application_program ap on a.id = ap.applicationId
		join programs p on p.id = ap.programId
		join academy_location al on al.id=ap.academyLocationId and al.academyId in (select s from tbl_str_to_row) 
		join prog_batch_seat_config absc on ap.progBatchSeatConfigId=absc.id
		join batches b on b.id = absc.programBatchId and b.intakeYearId = varIntakeYear
		where a.currentStatus in ('APPROVED','ADMISSION GRANTED')
		group by al.academyId, b.intakeYearId) as tot_aprvd_ap
set tbl.currAprvd_ap = tot_aprvd_ap.tot_aprvd_Ap
where tot_aprvd_ap.aId = tbl.academyId and tot_aprvd_ap.intakeYearId = tbl.currIntakeYrId;

/********************* previous approved application ***************************/
update tbl_rpt_sales_admission_summary as tbl, 
(Select al.academyId as aId, count(distinct a.code) as tot_aprvd_Ap, b.intakeYearId
		from application a join application_program ap on a.id = ap.applicationId
		join programs p on p.id = ap.programId
		join academy_location al on al.id=ap.academyLocationId and al.academyId in (select s from tbl_str_to_row) 
		join prog_batch_seat_config absc on ap.progBatchSeatConfigId=absc.id
		join batches b on b.id = absc.programBatchId and b.intakeYearId = vIntakeYrPrev
		where a.currentStatus in ('APPROVED','ADMISSION GRANTED')
		group by al.academyId, b.intakeYearId) as tot_aprvd_ap
set tbl.prevAprvdAp = tot_aprvd_ap.tot_aprvd_Ap
where tot_aprvd_ap.aId = tbl.academyId and tot_aprvd_ap.intakeYearId = tbl.prevIntakeYrId;

/**************************** current enrolment ********************************/
update tbl_rpt_sales_admission_summary as tbl, 
(select count(distinct a.id) as tot_admissions, al.academyId, b.intakeYearId
  	from admission as a join prog_batch_seat_config absc on a.programBatchSeatConfigId = absc.id
		join application_admission_detail as aad on a.applicationProgramId = aad.applicationProgramId
		join batches b on b.id = absc.programBatchId and b.intakeYearId = varIntakeYear
		join programs p on p.id = b.programId
		join academy_location as al on p.academyLocationId = al.id and al.academyId in (select s from tbl_str_to_row) 
		group by al.academyId, b.intakeYearId) as tot_adm
set tbl.currEnrol = tot_adm.tot_admissions
where tot_adm.academyId = tbl.academyId and tot_adm.intakeYearId = tbl.currIntakeYrId;

/**************************** previous enrolment *******************************/
update tbl_rpt_sales_admission_summary as tbl, 
(select count(distinct a.id) as tot_admissions, al.academyId, b.intakeYearId
  	from admission as a join prog_batch_seat_config absc on a.programBatchSeatConfigId = absc.id
		join application_admission_detail as aad on a.applicationProgramId = aad.applicationProgramId
		join batches b on b.id = absc.programBatchId and b.intakeYearId = vIntakeYrPrev
		join programs p on p.id = b.programId
		join academy_location as al on p.academyLocationId = al.id
		group by al.academyId, b.intakeYearId) as tot_adm
set tbl.prevEnrol = tot_adm.tot_admissions
where tot_adm.academyId = tbl.academyId and tot_adm.intakeYearId = tbl.prevIntakeYrId;

/*	select o.orgName, al.academyName, al.academyId, i.itemValue, i.id as intakeYearId
	, tot_leads.enq_cnt as enq_cnt
	, tot_ap.Total_SUCCESSFUL_Admission as tot_app
	, tot_adm.tot_admissions as tot_adm
	from  organizations as o
	join academies as a on o.id = a.organizationId
	join academy_location al on al.academyId = a.id
	join user_academy_locations as ual on ual.academyLocationId = al.id
	join users as u on u.id = ual.userId and u.id = varUserId
	join programs p on al.id = p.academyLocationId
  	join batches as b on p.id = b.programId and b.intakeYearId in (select id as iy from intake_year where id = varIntakeYear
		union select i1.id as iy from intake_year as i1, intake_year as i2 where i1.itemValue = i2.itemValue - 1 and i2.id = varIntakeYear)
	join intake_year as i on i.id = b.intakeYearId
left join (select count(distinct e.code) as enq_cnt, b.intakeYearId, al.academyId
from enquiry as e join academy_location as al on e.academyLocationId = al.id
	join user_academy_locations as ual on ual.academyLocationId = al.id
	join users as u on u.id = ual.userId and u.id = varUserId
	join programs p on al.id = p.academyLocationId
  	join batches as b on p.id = b.programId and b.intakeYearId in (select id as iy from intake_year where id = varIntakeYear
		union select i1.id as iy from intake_year as i1, intake_year as i2 where i1.itemValue = i2.itemValue - 1 and i2.id = varIntakeYear)
group by al.academyId, b.intakeYearId) as tot_leads
on (tot_leads.intakeYearId = i.id and tot_leads.academyId = al.academyId)
left join
(Select al.academyId as aId, count(distinct a.code) as Total_SUCCESSFUL_Admission, b.intakeYearId
		from application a join application_program ap on a.id = ap.applicationId
		join programs p on p.id = ap.programId
		join academy_location al on al.id=ap.academyLocationId
		join user_academy_locations as ual on ual.academyLocationId = al.id
		join users as u on u.id = ual.userId and u.id = varUserId
		join prog_batch_seat_config absc on ap.progBatchSeatConfigId=absc.id
		join batches b on b.id = absc.programBatchId and b.intakeYearId in (select id as iy from intake_year where id = varIntakeYear
		union select i1.id as iy from intake_year as i1, intake_year as i2 where i1.itemValue = i2.itemValue - 1 and i2.id = varIntakeYear)
		group by al.academyId, b.intakeYearId) as tot_ap
on (tot_ap.aId = al.academyId and tot_ap.intakeYearId = i.id)
left join
(select count(distinct a.id) as tot_admissions, al.academyId, b.intakeYearId
  	from admission as a join prog_batch_seat_config absc on a.programBatchSeatConfigId = absc.id
		join application_admission_detail as aad on a.applicationProgramId = aad.applicationProgramId
		join batches b on b.id = absc.programBatchId and b.intakeYearId in (select id as iy from intake_year where id = varIntakeYear
		union select i1.id as iy from intake_year as i1, intake_year as i2 where i1.itemValue = i2.itemValue - 1 and i2.id = varIntakeYear)
		join programs p on p.id = b.programId
		join academy_location as al on p.academyLocationId = al.id
		join user_academy_locations as ual on ual.academyLocationId = al.id
		join users as u on u.id = ual.userId and u.id = varUserId
	group by al.academyId, b.intakeYearId) as tot_adm
on tot_adm.academyId = al.academyId and tot_adm.intakeYearId = i.id
group by al.academyId, i.id;
*/

-- select currIntakeYr;

update tbl_rpt_sales_admission_summary
set perc_leads_ap = currAp / currLeads * 100,
	perc_leads_aprvd_ap = currAprvd_ap / currLeads * 100,
	perc_leads_enrol = currEnrol / currLeads * 100,
	prev_perc_leads_ap = prevAp / prevLeads * 100,
	prev_perc_leads_aprvd_ap = prevAprvdAp / prevLeads * 100,
	prev_perc_leads_enrol = prevEnrol / prevLeads * 100, 
	perc_prev_stg_ap = currAp / currLeads * 100, 
	perc_prev_stg_aprvd_ap = currAprvd_ap / currAp * 100, 
	perc_prev_stg_enrol = currEnrol / currAprvd_ap * 100, 
	prev_perc_prev_stg_ap = prevAp / prevLeads * 100, 
	prev_perc_prev_stg_aprvd_ap = prevAprvdAp / prevAp * 100, 
	prev_perc_prev_stg_enrol = prevEnrol / prevAprvdAp * 100, 
	abs_chng_leads = currLeads - prevLeads,
	abs_chng_ap = currAp - prevAp, 
	abs_chng_aprvd_ap = currAprvd_ap - prevAprvdAp, 
	abs_chng_enrol = currEnrol - prevEnrol,
	abs_perc_chng_leads = ((currLeads - prevLeads) / currLeads) * 100, 
	abs_perc_chng_ap = ((currAp - prevAp) / currAp) * 100, 
	abs_perc_chng_aprvd_ap = ((currAprvd_ap - prevAprvdAp) / currAprvd_ap) * 100, 
	abs_perc_chng_enrol = ((currEnrol - prevEnrol) / currEnrol) * 100;

	update tbl_rpt_sales_admission_summary as tbl, (select sum(currLeads) as currLeadsOrg, sum(currAp) as currApOrg
		, sum(currAprvd_ap) as currAprvdApOrg, sum(currEnrol) as currEnrolOrg
		from tbl_rpt_sales_admission_summary) as t
	set tbl.org_perc_leads_ap = t.currApOrg / t.currLeadsOrg * 100;

	update tbl_rpt_sales_admission_summary as tbl, (select sum(currLeads) as currLeadsOrg, sum(currAp) as currApOrg
		, sum(currAprvd_ap) as currAprvdApOrg, sum(currEnrol) as currEnrolOrg, sum(prevLeads) as prevLeadsOrg
		, sum(prevAp) as prevApOrg, sum(prevAprvdAp) as prevAprvdApOrg, sum(prevEnrol) as prevEnrolOrg
		from tbl_rpt_sales_admission_summary) as t
	set tbl.currLeadsOrg = t.currLeadsOrg, 
		tbl.currApOrg = t.currApOrg, 
		tbl.currAprvdApOrg = t.currAprvdApOrg, 
		tbl.currEnrolOrg = t.currEnrolOrg, 
		tbl.prevLeadsOrg = t.prevLeadsOrg, 
		tbl.prevApOrg = t.prevApOrg, 
		tbl.prevAprvdApOrg = t.prevAprvdApOrg, 
		tbl.prevEnrolOrg = t.prevEnrolOrg,
		tbl.org_perc_leads_ap = t.currApOrg / t.currLeadsOrg * 100,
		tbl.org_perc_leads_aprvd_ap = t.currAprvdApOrg / t.currLeadsOrg * 100, 
		tbl.org_perc_leads_enrol= t.currEnrolOrg / t.currLeadsOrg * 100, 

		tbl.org_prev_perc_leads_ap = t.prevApOrg / t.prevLeadsOrg * 100, 
		tbl.org_prev_perc_leads_aprvd_ap = t.prevAprvdApOrg / t.prevLeadsOrg * 100, 
		tbl.org_prev_perc_leads_enrol = t.prevEnrolOrg / t.prevLeadsOrg * 100,

		tbl.org_perc_prev_stg_ap = t.currApOrg / t.currLeadsOrg * 100,
		tbl.org_perc_prev_stg_aprvd_ap = t.currAprvdApOrg / t.currApOrg * 100,
		tbl.org_perc_prev_stg_enrol = t.currEnrolOrg / t.currAprvdApOrg * 100,

		tbl.org_prev_perc_prev_stg_ap = t.prevApOrg / t.prevLeadsOrg * 100, 
		tbl.org_prev_perc_prev_stg_aprvd_ap = t.prevAprvdApOrg / t.prevApOrg * 100,
		tbl.org_prev_perc_prev_stg_enrol = t.prevEnrolOrg / t.prevAprvdApOrg * 100, 

		tbl.org_abs_chng_leads = t.currLeadsOrg - t.prevLeadsOrg, 
		tbl.org_abs_chng_ap = t.currApOrg - t.prevApOrg,
		tbl.org_abs_chng_aprvd_ap = t.currAprvdApOrg - t.prevAprvdApOrg, 
		tbl.org_abs_chng_enrol = t.currEnrolOrg - t.prevEnrolOrg, 

		tbl.org_abs_perc_chng_leads = ((t.currLeadsOrg - t.prevLeadsOrg) / t.currLeadsOrg) * 100, 
		tbl.org_abs_perc_chng_ap = ((t.currApOrg - t.prevApOrg) / t.currApOrg) * 100, 
		tbl.org_abs_perc_chng_aprvd_ap = ((t.currAprvdApOrg - t.prevAprvdApOrg) / t.currAprvdApOrg) * 100, 
		tbl.org_abs_perc_chng_enrol = ((t.currEnrolOrg - t.prevEnrolOrg) / t.currEnrolOrg) * 100
;
/*	org_perc_leads_aprvd_ap double(7,2), org_perc_leads_enrol double(7,2)
	, org_prev_perc_leads_ap double(7,2), org_prev_perc_leads_aprvd_ap double(7,2), org_prev_perc_leads_enrol double(7,2)
*/
set sql_safe_updates = 1;

select orgName, academyId, academyName, currIntakeYr, currIntakeYrId, currLeads, currAp
	, currAprvd_ap, currEnrol, prevIntakeYr, prevIntakeYrId, prevLeads, prevAp, prevAprvdAp
	, prevEnrol, perc_leads_ap, perc_leads_aprvd_ap, perc_leads_enrol, prev_perc_leads_ap
	, prev_perc_leads_aprvd_ap, prev_perc_leads_enrol, perc_prev_stg_ap, perc_prev_stg_aprvd_ap
	, perc_prev_stg_enrol, prev_perc_prev_stg_ap, prev_perc_prev_stg_aprvd_ap, prev_perc_prev_stg_enrol
	, abs_chng_leads, abs_chng_ap, abs_chng_aprvd_ap, abs_chng_enrol, abs_perc_chng_leads
	, abs_perc_chng_ap, abs_perc_chng_aprvd_ap, abs_perc_chng_enrol, currLeadsOrg, currApOrg
	, currAprvdApOrg, currEnrolOrg, prevLeadsOrg, prevApOrg, prevAprvdApOrg, prevEnrolOrg
	, org_perc_leads_ap, org_perc_leads_aprvd_ap, org_perc_leads_enrol
	, org_prev_perc_leads_ap, org_prev_perc_leads_aprvd_ap
	, org_prev_perc_leads_enrol, org_perc_prev_stg_ap, org_perc_prev_stg_aprvd_ap, org_perc_prev_stg_enrol
	, org_prev_perc_prev_stg_ap, org_prev_perc_prev_stg_aprvd_ap, org_prev_perc_prev_stg_enrol, org_abs_chng_leads
	, org_abs_chng_ap, org_abs_chng_aprvd_ap, org_abs_chng_enrol, org_abs_perc_chng_leads, org_abs_perc_chng_ap
	, org_abs_perc_chng_aprvd_ap, org_abs_perc_chng_enrol
from tbl_rpt_sales_admission_summary;


END$$

DELIMITER ;