CREATE TABLE lesson_plan_duration (
  id bigint(20) NOT NULL AUTO_INCREMENT PRIMARY KEY,
  itemCode varchar(255) NOT NULL,
  itemValue varchar(255) NOT NULL,
  lastUpdate timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  lastUpdatedBy bigint(20) NOT NULL,
  CONSTRAINT RefusersLessonPlanDuration FOREIGN KEY (lastUpdatedBy) REFERENCES users(id)
	ON DELETE RESTRICT ON UPDATE RESTRICT,
  UNIQUE KEY id_unk_lesson_plan_duration(itemCode, itemValue)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 comment = 'Duration of Lesson Plan, Master table';

INSERT INTO standard_master(tableName, masterName, moduleName, filterCode, whetherChild, whetherParent, droolsAgenda, displayValue, lastUpdatedBy, lastUpdate)
VALUES('lesson_plan_duration', 'LESSON_PLAN_DURATION', 'Program & Courses', 'COMMON_MASTER', 0, 0, null, null, 1, sysdate());
SET @standardMasterMaxId = (SELECT id FROM standard_master where tableName = 'lesson_plan_duration');

INSERT INTO standard_master_items(dbFieldName, fieldLabel, standardMasterId, fieldType, emunType, diaplayOrder, whetherForeignKey, fkTable, fkFieldName, fkDisplayField, whetherShortCode, whetherReadOnly, wheherNullable, validationType, maxLength, minLength, lastUpdatedBy, lastUpdate)
VALUES('itemCode', 'itemCode', @standardMasterMaxId, 'varchar', null, 1, 0, null, null, null, 0, 0, 0, null, null, null, 1, sysdate()),
('itemValue', 'itemValue', @standardMasterMaxId, 'varchar', null, 2, 0, null, null, null, 0, 0, 0, null, null, null, 1, sysdate());

CREATE TABLE objective (
  id bigint(20) NOT NULL AUTO_INCREMENT PRIMARY KEY,
  itemCode varchar(255) NOT NULL,
  itemValue varchar(255) NOT NULL,
  lastUpdate timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  lastUpdatedBy bigint(20) NOT NULL,
  CONSTRAINT RefusersLPObjective FOREIGN KEY (lastUpdatedBy) REFERENCES users(id)
	ON DELETE RESTRICT ON UPDATE RESTRICT,
  UNIQUE KEY id_unk_objective(itemCode, itemValue)
) ENGINE = InnoDB DEFAULT CHARSET = utf8 comment = 'Objective(Master table) of Lesson Plan and has Objective and subObjective both.';

INSERT INTO standard_master(tableName, masterName, moduleName, filterCode, whetherChild, whetherParent, droolsAgenda, displayValue, lastUpdatedBy, lastUpdate)
VALUES('objective', 'objective', 'Program & Courses', 'COMMON_MASTER', 0, 0, null, null, 1, sysdate());

SET @standardMasterMaxId = (SELECT id FROM standard_master where tableName = 'objective');

INSERT INTO standard_master_items(dbFieldName, fieldLabel, standardMasterId, fieldType, emunType, diaplayOrder, whetherForeignKey, fkTable, fkFieldName, fkDisplayField, whetherShortCode, whetherReadOnly, wheherNullable, validationType, maxLength, minLength, lastUpdatedBy, lastUpdate)
VALUES('itemCode', 'ITEM_CODE', @standardMasterMaxId, 'varchar', null, 1, 0, null, null, null, 0, 0, 0, null, null, null, 1, sysdate()),
('itemValue', 'ITEM_VALUE', @standardMasterMaxId, 'varchar', null, 2, 0, null, null, null, 0, 0, 0, null, null, null, 1, sysdate());

create table lesson_plan(
  id bigint(20) NOT NULL AUTO_INCREMENT PRIMARY KEY,
  academicTermId bigint(20) NOT NULL,
  courseId bigint(20) NOT NULL,
  facultyId bigint(20) NOT NULL,
  unitTitle varchar(255) not null,
  topics  varchar(255) not null,
  term varchar(50) not null,
  durationId bigint(20) not null,
  aim text not null,
  preRequisites text,
  dateOfPlan date not null,
  lastUpdate timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  lastUpdatedBy bigint(20) NOT NULL,
  CONSTRAINT RefusersLessonPlan FOREIGN KEY (lastUpdatedBy) REFERENCES users(id)
	ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT RefacademicTermLessonPlan FOREIGN KEY (academicTermId) REFERENCES academic_term(id)
	ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT RefcoursesLessonPlan FOREIGN KEY (courseId) REFERENCES courses(id)
	ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT RefstaffsLessonPlan FOREIGN KEY (facultyId) REFERENCES staffs(userId)
	ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT RefLessonPlanDurationLessonPlan FOREIGN KEY (durationId) REFERENCES lesson_plan_duration(id)
	ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=utf8 comment = 'Lesson Plan Master';

create table lesson_plan_course_variant(id bigint(20) NOT NULL AUTO_INCREMENT PRIMARY KEY,
  lessonPlanId bigint(20) NOT NULL,
  courseVariantId bigint(20) NOT NULL,
  lastUpdate timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  lastUpdatedBy bigint(20) NOT NULL,
  CONSTRAINT RefusersLessonPlanCV FOREIGN KEY (lastUpdatedBy) REFERENCES users(id)
	ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT ReflpLessonPlanCV FOREIGN KEY (lessonPlanId) REFERENCES lesson_plan(id)
	ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT RefcourseVariantLessonPlanCV FOREIGN KEY (courseVariantId) REFERENCES course_variants(id)
	ON DELETE RESTRICT ON UPDATE RESTRICT,
  UNIQUE KEY id_unk_lesson_plan_course_variant(lessonPlanId, courseVariantId)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 comment = 'Lesson Plan and Course Variant Tables mapping, might be one to many';

create table lesson_plan_objective(id bigint(20) NOT NULL AUTO_INCREMENT PRIMARY KEY,
  lessonPlanId bigint(20) NOT NULL,
  ObjectiveId bigint(20) NOT NULL,
  isSubObjectiveRequired boolean default 1 comment '1 is required, 0 is not required',
  remark text,
  lastUpdate timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  lastUpdatedBy bigint(20) NOT NULL,
  CONSTRAINT RefusersLessonPlanObjective FOREIGN KEY (lastUpdatedBy) REFERENCES users(id)
	ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT ReflpLessonPlanObjective FOREIGN KEY (lessonPlanId) REFERENCES lesson_plan(id)
	ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT RefObjectiveLessonPlanObjective FOREIGN KEY (ObjectiveId) REFERENCES objective(id)
	ON DELETE RESTRICT ON UPDATE RESTRICT,
  UNIQUE KEY id_unk_lesson_plan_objective(lessonPlanId, ObjectiveId)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 comment = 'Objective of Lesson Plan, Transactional Table';

create table lesson_plan_sub_objective(id bigint(20) NOT NULL AUTO_INCREMENT PRIMARY KEY,
  lessonPlanObjectiveId bigint(20) NOT NULL,
  SubObjectiveId bigint(20) NOT NULL,
  remark text,
  lastUpdate timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  lastUpdatedBy bigint(20) NOT NULL,
  CONSTRAINT RefusersLessonPlanSubObjective FOREIGN KEY (lastUpdatedBy) REFERENCES users(id)
	ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT ReflessonPlanObjectiveSubObjective FOREIGN KEY (lessonPlanObjectiveId) REFERENCES lesson_plan_objective(id)
	ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT RefobjectiveLessonPlanSubObjective FOREIGN KEY (SubObjectiveId) REFERENCES objective(id)
	ON DELETE RESTRICT ON UPDATE RESTRICT,
  UNIQUE KEY id_unk_lesson_plan_sub_objective(lessonPlanObjectiveId, SubObjectiveId)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 comment = 'Sub-Objective of Lesson Plan, Transactional Table';

create table lesson_plan_document(id bigint(20) NOT NULL AUTO_INCREMENT PRIMARY KEY,
  lessonPlanId bigint(20) NOT NULL,
  documentId bigint(20) NOT NULL,
  lastUpdate timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  lastUpdatedBy bigint(20) NOT NULL,
  CONSTRAINT RefusersLessonPlanDocument FOREIGN KEY (lastUpdatedBy) REFERENCES users(id)
	ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT ReflplessonPlanDocument FOREIGN KEY (lessonPlanId) REFERENCES lesson_plan(id)
	ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT RefdocumentLessonPlanDocument FOREIGN KEY (documentId) REFERENCES documents(id)
	ON DELETE RESTRICT ON UPDATE RESTRICT,
  UNIQUE KEY id_unk_lesson_plan_document(lessonPlanId, documentId)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 comment = 'Document upload for Lesson Plan, Transactional Table';