CREATE TABLE `student_transfer_request_details` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `fromALId` bigint(20) NOT NULL,
  `toALId` bigint(20) NOT NULL,
  `fromProgramId` bigint(20) NOT NULL,
  `toProgramId` bigint(20) NOT NULL,
  `serviceRequestId` bigint(20) NOT NULL,
  `version` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `toBatchId` bigint(20) NOT NULL,
  `isRetainStudentData` bit(1) DEFAULT b'0',
  `isRetainAcademicData` bit(1) DEFAULT b'0',
  `isRetainServicesOpted` bit(1) DEFAULT b'0',
  `isRetainFeesPaymentData` bit(1) DEFAULT b'0',
  `effectiveTransferDate` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `Refst2298` (`fromProgramId`),
  KEY `st_xfer_user_fk` (`lastUpdatedBy`),
  KEY `serviceRequestId` (`serviceRequestId`),
  KEY `toBatchId` (`toBatchId`),
  KEY `fk_strd_to_program` (`toProgramId`),
  KEY `fk_strd_from_AL_Id_idx` (`fromALId`),
  KEY `fk_strd_to_AL_Id_idx` (`toALId`),
  CONSTRAINT `fk_strd_batchId` FOREIGN KEY (`toBatchId`) REFERENCES `batches` (`id`),
  CONSTRAINT `fk_strd_from_AL_Id` FOREIGN KEY (`fromALId`) REFERENCES `academy_location` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_strd_from_program` FOREIGN KEY (`fromProgramId`) REFERENCES `programs` (`id`),
  CONSTRAINT `fk_strd_lastUpdated` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`),
  CONSTRAINT `fk_strd_service_requestId` FOREIGN KEY (`serviceRequestId`) REFERENCES `service_requests` (`id`),
  CONSTRAINT `fk_strd_to_AL_Id` FOREIGN KEY (`toALId`) REFERENCES `academy_location` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_strd_to_program` FOREIGN KEY (`toProgramId`) REFERENCES `programs` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;