SET SQL_SAFE_UPDATES = 0;
ALTER TABLE `evaluation_type` 
ADD COLUMN `isResultPublish` BIT(1) NOT NULL DEFAULT b'1' AFTER `evaluationType`;

ALTER TABLE `evaluation_sub_type` 
ADD COLUMN `isResultPublish` BIT(1) NOT NULL DEFAULT b'1' AFTER `evaluationSubType`;

ALTER TABLE `evaluation_plan_other_category` 
ADD COLUMN `isResultPublish` BIT(1) NOT NULL DEFAULT b'1' AFTER `categoryName`;

ALTER TABLE `evaluation_plan_other_sub_category` 
ADD COLUMN `isResultPublish` BIT(1) NOT NULL DEFAULT b'1' AFTER `subCategoryName`;

ALTER TABLE `evaluation_plan` 
ADD COLUMN `isResultPublish` BIT(1) NOT NULL DEFAULT b'1' AFTER `roundingMode`,
ADD COLUMN `resultPublishMode` VARCHAR(255) NOT NULL DEFAULT 'ADMIN_APPROVAL' AFTER `isResultPublish`;

ALTER TABLE `eval_seq_detail` 
ADD COLUMN `isResultPublish` BIT(1) NOT NULL DEFAULT b'1' AFTER `roundingMode`,
ADD COLUMN `resultPublishMode` VARCHAR(255) NOT NULL DEFAULT 'ADMIN_APPROVAL' AFTER `isResultPublish`;

ALTER TABLE `sequence_header` 
ADD COLUMN `isResultPublish` BIT(1) NOT NULL DEFAULT b'1' AFTER `sequenceCode`;

ALTER TABLE `evaluation_plan_level_one` 
ADD COLUMN `resultPublishMode` VARCHAR(255) NOT NULL DEFAULT 'ADMIN_APPROVAL' AFTER `roundingMode`;

ALTER TABLE `evaluation_plan_level_two` 
ADD COLUMN `resultPublishMode` VARCHAR(255) NOT NULL DEFAULT 'ADMIN_APPROVAL' AFTER `roundingMode`;

ALTER TABLE `evaluation_sequence` 
ADD COLUMN `resultPublishMode` VARCHAR(255) NOT NULL DEFAULT 'ADMIN_APPROVAL' AFTER `roundingMode`;

ALTER TABLE `evaluation_plan_rank` 
ADD COLUMN `isResultPublish` BIT(1) NOT NULL DEFAULT b'0' AFTER `resultApproverId`,
ADD COLUMN `resultPublishBy` BIGINT(20) NULL DEFAULT NULL AFTER `isResultPublish`,
ADD COLUMN `resultPublishDate` TIMESTAMP NULL DEFAULT NULL AFTER `resultPublishBy`,
ADD INDEX `fk_evaluation_plan_resultPublishBy_idx` (`resultPublishBy` ASC);
ALTER TABLE `evaluation_plan_rank` 
ADD CONSTRAINT `fk_evaluation_plan_resultPublishBy`
  FOREIGN KEY (`resultPublishBy`)
  REFERENCES `users` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;

ALTER TABLE `evaluation_plan_level_one_rank` 
ADD COLUMN `isResultPublish` BIT(1) NOT NULL DEFAULT b'0' AFTER `isCarryforward`,
ADD COLUMN `resultPublishBy` BIGINT(20) NULL DEFAULT NULL AFTER `isResultPublish`,
ADD COLUMN `resultPublishDate` TIMESTAMP NULL DEFAULT NULL AFTER `resultPublishBy`,
ADD INDEX `fk_evaluation_plan_level_one_resultPublishBy_idx` (`resultPublishBy` ASC);
ALTER TABLE `evaluation_plan_level_one_rank` 
ADD CONSTRAINT `fk_evaluation_plan_level_one_resultPublishBy`
  FOREIGN KEY (`resultPublishBy`)
  REFERENCES `users` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;

ALTER TABLE `evaluation_plan_level_two_rank` 
ADD COLUMN `isResultPublish` BIT(1) NOT NULL DEFAULT b'0' AFTER `isCarryforward`,
ADD COLUMN `resultPublishBy` BIGINT(20) NULL DEFAULT NULL AFTER `isResultPublish`,
ADD COLUMN `resultPublishDate` TIMESTAMP NULL DEFAULT NULL AFTER `resultPublishBy`,
ADD INDEX `fk_evaluation_plan_level_two_resultPublishBy_idx` (`resultPublishBy` ASC);
ALTER TABLE `evaluation_plan_level_two_rank` 
ADD CONSTRAINT `fk_evaluation_plan_level_two_resultPublishBy`
  FOREIGN KEY (`resultPublishBy`)
  REFERENCES `users` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;


ALTER TABLE `evaluation_sequence_rank` 
ADD COLUMN `isResultPublish` BIT(1) NOT NULL DEFAULT b'0' AFTER `isCarryforward`,
ADD COLUMN `resultPublishBy` BIGINT(20) NULL DEFAULT NULL AFTER `isResultPublish`,
ADD COLUMN `resultPublishDate` TIMESTAMP NULL DEFAULT NULL AFTER `resultPublishBy`,
ADD INDEX `fk_evaluation_sequence_rank_resultPublishBy_idx` (`resultPublishBy` ASC);
ALTER TABLE `evaluation_sequence_rank` 
ADD CONSTRAINT `fk_evaluation_sequence_rank_resultPublishBy`
  FOREIGN KEY (`resultPublishBy`)
  REFERENCES `users` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;

ALTER TABLE `examination_result` 
ADD COLUMN `resultPublishBy` BIGINT(20) NULL DEFAULT NULL AFTER `studentRemarkSubmitted`,
ADD INDEX `fk_examination_result_resultPublishBy_idx` (`resultPublishBy` ASC);
ALTER TABLE `examination_result` 
ADD CONSTRAINT `fk_examination_result_resultPublishBy`
  FOREIGN KEY (`resultPublishBy`)
  REFERENCES `users` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;


ALTER TABLE `evaluation_plan_level_one` 
ADD COLUMN `evaluationTypeId` BIGINT(20) NULL DEFAULT NULL AFTER `evaluationPlanId`,
ADD COLUMN `evaluationPlanOtherCategoryId` BIGINT(20) NULL DEFAULT NULL AFTER `evaluationTypeId`,
ADD INDEX `fk_evaluation_plan_level_one_evaluationTypeId_idx` (`evaluationTypeId` ASC),
ADD INDEX `fk_evaluation_plan_level_one_evaluationPlanOtherCategoryId_idx` (`evaluationPlanOtherCategoryId` ASC);
ALTER TABLE `evaluation_plan_level_one` 
ADD CONSTRAINT `fk_evaluation_plan_level_one_evaluationTypeId`
  FOREIGN KEY (`evaluationTypeId`)
  REFERENCES `evaluation_type` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT,
ADD CONSTRAINT `fk_evaluation_plan_level_one_evaluationPlanOtherCategoryId`
  FOREIGN KEY (`evaluationPlanOtherCategoryId`)
  REFERENCES `evaluation_plan_other_category` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;
  
  
ALTER TABLE `evaluation_plan_level_two` 
ADD COLUMN `evaluationSubTypeId` BIGINT(20) NULL DEFAULT NULL AFTER `evalPlanLevelOneId`,
ADD COLUMN `evaluationPlanOtherSubCategoryId` BIGINT(20) NULL DEFAULT NULL AFTER `evaluationSubTypeId`,
ADD INDEX `fk_evaluation_plan_level_two_evaluationSubTypeId_idx` (`evaluationSubTypeId` ASC),
ADD INDEX `fk_evaluation_plan_level_two_evaluationPlanOtherSubCategory_idx` (`evaluationPlanOtherSubCategoryId` ASC);
ALTER TABLE `evaluation_plan_level_two` 
ADD CONSTRAINT `fk_evaluation_plan_level_two_evaluationSubTypeId`
  FOREIGN KEY (`evaluationSubTypeId`)
  REFERENCES `evaluation_sub_type` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT,
ADD CONSTRAINT `fk_evaluation_plan_level_two_evaluationPlanOtherSubCategoryId`
  FOREIGN KEY (`evaluationPlanOtherSubCategoryId`)
  REFERENCES `evaluation_plan_other_sub_category` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;
  
ALTER TABLE  `standard_master_items` 
CHANGE COLUMN `fieldType` `fieldType` ENUM('Varchar', 'Date', 'Boolean', 'Enum', 'Number', 'Double', 'RadioGroup') NOT NULL ;
  

select id INTO @evaluationTypeSMId from standard_master where tableName='evaluation_type';
select id INTO @evaluationSubTypeSMId from standard_master  where tableName='evaluation_sub_type';
select id INTO @evaluationPlanOtherCategorySMId from standard_master where tableName='evaluation_plan_other_category';
select id INTO @evaluationPlanOtherSubCategorySMId from standard_master where tableName='evaluation_plan_other_sub_category';
 
INSERT INTO standard_master_items ( `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
VALUES ( 'isResultPublish', 'IS_RESULT_PUBLISH', @evaluationTypeSMId, 'RadioGroup', '2', 0, 0, 0, 0, '1', SYSDATE());

INSERT INTO standard_master_items ( `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
VALUES ( 'isResultPublish', 'IS_RESULT_PUBLISH', @evaluationSubTypeSMId, 'RadioGroup', '2', 0, 0, 0, 0, '1', SYSDATE());

INSERT INTO standard_master_items ( `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
VALUES ( 'isResultPublish', 'IS_RESULT_PUBLISH', @evaluationPlanOtherCategorySMId, 'RadioGroup', '2', 0, 0, 0, 0, '1', SYSDATE());

INSERT INTO standard_master_items ( `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
VALUES ( 'isResultPublish', 'IS_RESULT_PUBLISH', @evaluationPlanOtherSubCategorySMId, 'RadioGroup', '2', 0, 0, 0, 0, '1', SYSDATE());  


SET SQL_SAFE_UPDATES = 1;
