INSERT INTO `ui_translation` ( `objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `lastUpdate`, `lastUpdatedBy`) 
VALUES ('COURSETX', 'TRANSFER_SECTION_DETAILS', 'Transfer Section Details', 'Transfer Section Details', SYSDATE(), '1');



DROP PROCEDURE IF EXISTS sectionTransferCBSForExam;

DELIMITER $$
CREATE PROCEDURE sectionTransferCBSForExam(IN courseId BIGINT(20),IN fromSectionId BIGINT(20),IN toSectionId BIGINT(20),
IN admissionIdString VARCHAR(2048))
BEGIN
	DECLARE toCourseVariantId, fromCourseVariantId, fromPlanId, toPlanId BIGINT(20);
-- create temporary table if not exists temp_table (msg varchar(2048));
-- delete from temp_table;
START TRANSACTION;
-- insert into temp_table set msg ='Transaction started';
BLOCK1: begin
	set fromPlanId := (select etc.evaluationPlanId from evaluation_type_course as etc
	join course_variants cv on etc.courseVariantId=cv.id
	join courses course on cv.courseId=course.id
	where etc.sectionId =fromSectionId and (cv.courseId=courseId or course.parentCourseId=courseId)
	group by etc.evaluationPlanId);
-- insert into temp_table set msg ='From plan id executed';
	set toPlanId := (select etc.evaluationPlanId from evaluation_type_course as etc
	join course_variants cv on etc.courseVariantId=cv.id
	join courses course on cv.courseId=course.id
	where etc.sectionId = toSectionId and (cv.courseId=courseId or course.parentCourseId=courseId)
	group by etc.evaluationPlanId);
-- insert into temp_table set msg ='To plan id executed';
	if(fromPlanId=toPlanId)
	then
-- insert into temp_table set msg ='Plan checked';
		set toCourseVariantId := (select etc.courseVariantId from evaluation_type_course as etc
		join course_variants cv on etc.courseVariantId=cv.id
		join courses course on cv.courseId=course.id
		where etc.sectionId = toSectionId and (cv.courseId=courseId or course.parentCourseId=courseId) and etc.evaluationPlanId=fromPlanId);
-- insert into temp_table set msg =concat('To CV id executed toCourseVariantId-',toCourseVariantId);
		set fromCourseVariantId := (select evaluation_type_course.courseVariantId from evaluation_type_course
		join course_variants cv on evaluation_type_course.courseVariantId=cv.id
		join courses course on cv.courseId=course.id
		where evaluation_type_course.sectionId = fromSectionId and (cv.courseId=courseId or course.parentCourseId=courseId) and evaluation_type_course.evaluationPlanId=fromPlanId);
-- insert into temp_table set msg =concat('from CV id executed toCourseVariantId-',toCourseVariantId);
-- insert into temp_table set msg =concat('from CV id executed fromCourseVariantId-',fromCourseVariantId);
		if(toCourseVariantId is not null && fromCourseVariantId is not null)
		then
-- insert into temp_table set msg =concat('CV check executed toCourseVariantId-',toCourseVariantId,'toSectionId-','admissionIdString-',admissionIdString,'fromCourseVariantId-','fromSectionId-',fromSectionId);
			set sql_safe_updates=0;
			set @sql = concat("update examination_result set courseVariantId=",toCourseVariantId,", sectionId=",toSectionId," where admissionId IN (",admissionIdString,") and courseVariantId=",fromCourseVariantId," and sectionId=",fromSectionId);

-- insert into temp_table set msg ='examination_result data updated';
-- insert into temp_table set msg = @sql;
		   PREPARE stmt FROM @sql;
		   EXECUTE stmt;
			set @sql = concat("update examination_result_history set courseVariantId=",toCourseVariantId,", sectionId=",toSectionId," where admissionId IN (",admissionIdString,") and courseVariantId=",fromCourseVariantId," and sectionId=",fromSectionId);
-- insert into temp_table set msg ='examination_result_history data updated';
-- insert into temp_table set msg = @sql;
		   PREPARE stmt FROM @sql;
		   EXECUTE stmt;
			set @sql = concat("update exam_result_event_students set courseVariantId=",toCourseVariantId,", sectionId=",toSectionId," where admissionId IN (",admissionIdString,") and courseVariantId=",fromCourseVariantId," and sectionId=",fromSectionId);
-- insert into temp_table set msg ='exam_result_event_students data updated';
-- insert into temp_table set msg = @sql;
		   PREPARE stmt FROM @sql;
		   EXECUTE stmt;
			set @sql = concat("update evaluation_sequence_rank set courseVariantId=",toCourseVariantId,", sectionId=",toSectionId," where admissionId IN (",admissionIdString,") and courseVariantId=",fromCourseVariantId," and sectionId=",fromSectionId);
-- insert into temp_table set msg ='evaluation_sequence_rank data updated';
-- insert into temp_table set msg = @sql;
		   PREPARE stmt FROM @sql;
		   EXECUTE stmt;
			set @sql = concat("update evaluation_plan_level_two_rank set courseVariantId=",toCourseVariantId,", sectionId=",toSectionId," where admissionId IN (",admissionIdString,") and courseVariantId=",fromCourseVariantId," and sectionId=",fromSectionId);
-- insert into temp_table set msg ='evaluation_plan_level_two_rank data updated';
-- insert into temp_table set msg = @sql;
		   PREPARE stmt FROM @sql;
		   EXECUTE stmt;
			set @sql = concat("update evaluation_plan_level_one_rank set courseVariantId=",toCourseVariantId,", sectionId=",toSectionId," where admissionId IN (",admissionIdString,") and courseVariantId=",fromCourseVariantId," and sectionId=",fromSectionId);
-- insert into temp_table set msg ='evaluation_plan_level_one_rank data updated';
-- insert into temp_table set msg = @sql;
		   PREPARE stmt FROM @sql;
		   EXECUTE stmt;
			set @sql = concat("update evaluation_plan_rank set courseVariantId=",toCourseVariantId,", sectionId=",toSectionId," where admissionId IN (",admissionIdString,") and courseVariantId=",fromCourseVariantId," and sectionId=",fromSectionId);
-- insert into temp_table set msg ='evaluation_plan_rank data updated';
-- insert into temp_table set msg = @sql;
		   PREPARE stmt FROM @sql;
		   EXECUTE stmt;
			set @sql = concat("update marksheet set courseVariantId=",toCourseVariantId,", sectionId=",toSectionId," where admissionId IN (",admissionIdString,") and courseVariantId=",fromCourseVariantId," and sectionId=",fromSectionId);
-- insert into temp_table set msg ='marksheet data updated';
-- insert into temp_table set msg = @sql;
		   PREPARE stmt FROM @sql;
		   EXECUTE stmt;
			set @sql = concat("update evaluation_student_remark set courseVariantId=",toCourseVariantId,", sectionId=",toSectionId," where admissionId IN (",admissionIdString,") and courseVariantId=",fromCourseVariantId," and sectionId=",fromSectionId);
-- insert into temp_table set msg ='evaluation_student_remark data updated';
-- insert into temp_table set msg = @sql;
		   PREPARE stmt FROM @sql;
		   EXECUTE stmt;
			set @sql = concat("update examination_repetition set courseVarientId=",toCourseVariantId," where admissionId IN (",admissionIdString,") and courseVarientId=",fromCourseVariantId);
-- insert into temp_table set msg ='examination_repetition data updated';
-- insert into temp_table set msg = @sql;
		   PREPARE stmt FROM @sql;
		   EXECUTE stmt;
			set @sql = concat("update examination_student_revaluation set courseVariantId=",toCourseVariantId," where admissionId IN (",admissionIdString,") and courseVariantId=",fromCourseVariantId);
-- insert into temp_table set msg ='examination_student_revaluation data updated';
-- insert into temp_table set msg = @sql;
		   PREPARE stmt FROM @sql;
		   EXECUTE stmt;
			set sql_safe_updates=1;
		end if;
	end if;
END BLOCK1;

COMMIT;    
END$$
DELIMITER ;

