DROP view IF EXISTS `Application_List_View`;

CREATE VIEW
`Application_List_View` AS
    SELECT 
        `T3`.`code` AS `APPLICATION_ID`,
        `T2`.`printName` AS `FULL_NAME`,
        `T2`.`firstName` AS `FIRST_NAME`,
        `T2`.`middleName` AS `MIDDLE_NAME`,
        `T2`.`lastName` AS `LAST_NAME`,
        `T20`.`academyName` AS `ACADEMY`,
        `T19`.`locationName` AS `LOCATION`,
        `T5`.`programName` AS `PROGRAM_NAME`,
        `PG`.`groupName` AS `PROGRAM_GROUP_NAME`,
        `T15`.`batchName` AS `BATCH`,
        `T8`.`seatName` AS `SEAT_TYPE`,
        `T52`.`whetherHostelApplicable` AS `HOSTEL_REQUIRED`,
        `T3`.`currentStatus` AS `APPLICATION_VIEW_STATUS`,
        `T51`.`value` AS `PROGRAM_WITHDRAWN_REASON`,
        `T1`.`currentStatus` AS `PROGRAM_VIEW_STATUS`,
        `T12`.`stageName` AS `CURRENT_STAGE`,
        `T1`.`offerLetterAcceptanceDate` AS `OFFER_LETTER_ACCEPTANCE_DATE`,
        `T9`.`currentStatus` AS `STAGE_VIEW_STATUS`,
        `T18`.`status` AS `ADMISSION_VIEW_STATUS`,
        `T3`.`applicationCreationSource` AS `APPLICATION_CREATION_SOURCE`,
        `T50`.`printName` AS `APPROVED_PERSON`,
        `T3`.`applicationApprovedOn` AS `APPLICATION_APPROVED_DATE`,
        `T3`.`applicationCreatedOn` AS `APPLICATION_DATE`,
        `T43`.`firstName` AS `FATHERS_FULL_NAME`,
        `T43`.`firstName` AS `FATHERS_FIRST_NAME`,
        `T43`.`middleName` AS `FATHERS_MIDDLE_NAME`,
        `T43`.`lastName` AS `FATHERS_LAST_NAME`,
        `T48`.`firstName` AS `MOTHERS_FULL_NAME`,
        `T48`.`firstName` AS `MOTHERS_FIRST_NAME`,
        `T48`.`middleName` AS `MOTHERS_MIDDLE_NAME`,
        `T48`.`lastName` AS `MOTHERS_LAST_NAME`,
        `T27`.`beneficiaryName` AS `BENEFICIARY_NAME`,
        `T27`.`accountNumber` AS `ACCOUNT_NUMBER`,
        `T27`.`accountType` AS `ACCOUNT_TYPE`,
        `T27`.`bankName` AS `BANK_NAME`,
        `T27`.`branchName` AS `BRANCH_NAME`,
        `T27`.`IFSCode` AS `IFSCODE`,
        `T2`.`birthDate` AS `DATE_OF_BIRTH`,
        `T2`.`gender` AS `GENDER`,
        `T2`.`category` AS `CATEGORY`,
        `T2`.`emailId` AS `EMAIL`,
        `T2`.`mobileCountryCode` AS `MOBILE_COUNTRY_CODE`,
        `T2`.`mobileNumber` AS `MOBILE_NUMBER`,
        `T2`.`phoneCountryCode` AS `PHONE_COUNTRY_CODE`,
        `T2`.`phoneAreaCode` AS `PHONE_AREA_CODE`,
        `T2`.`phoneNo` AS `PHONE_NO`,
        `T2`.`bloodGroup` AS `BLOOD_GROUP`,
        `T45`.`itemValue` AS `RELIGION`,
        `T46`.`itemValue` AS `CASTE_CATEGORY`,
        `T2`.`comments` AS `APPLICATION_GRID_COMMENTS`,
        `T10`.`whetherFeePlanApplicable` AS `WHETHER_FEE_PLAN_APPLICABLE`,
        `T44`.`billStatus` AS `BILL_STATUS`,
        `T3`.`currentStatus` AS `APPLICATION_STATUS`,
        `T1`.`currentStatus` AS `PROGRAM_STATUS`,
        `T9`.`currentStatus` AS `STAGE_STATUS`,
        `T14`.`status` AS `ADMISSION_STATUS`,
        `T49`.`itemValue` AS `NATIONALITY`,
        `T2`.`nationalID` AS `NATIONAL_ID`,
        `T2`.`printName` AS `APPLICATION_PERSON_PRINTNAME`,
        `T2`.`id` AS `APPLICATION_PERSON_ID`,
        `T14`.`id` AS `ADMISSION_PRIMERY_ID`,
        `T3`.`id` AS `APPLICATION_PRIMERY_ID`,
        `T1`.`id` AS `APPLICATION_PROGRAM_ID`,
        `T7`.`id` AS `PROG_BATCH_SEAT_CONFIG_ID`,
        `T1`.`academyLocationId` AS `ACADEMY_LOCATION_ID`,
        `T3`.`id` AS `ID`,
        `T26`.`externalUserId` AS `EXTERNAL_USER_ID`,
        `T7`.`id` AS `IS_OFFER_LETTER_APPLICABLE`,
        `country`.`countryName` AS `COUNTRY_NAME`,
        `cr`.`countryRegionName` AS `COUNTRY_REGION_NAME`,
        `city`.`cityName` AS `CITY_NAME`,
        `t89`.`itemCode` AS `intake_year`,
        `t89`.`id` AS `intakeYearId`,
        `address`.`id` AS `address_id`
    FROM
        ((((((((((((((((((((((((((((((((((`application` `T3`
        LEFT JOIN `external_user_association` `T26` ON (((`T3`.`id` = `T26`.`applicationId`)
            AND (`T26`.`referencyEntityType` = 'APPLICATION'))))
        JOIN `applicant_person` `T2` ON ((`T2`.`id` = `T3`.`applicantPersonId`)))
        LEFT JOIN `applicant_address` `address` ON (((`address`.`applicantPersonId` = `T2`.`id`)
            AND (`address`.`whetherPrimary` = 1))))
        LEFT JOIN `country` ON ((`country`.`id` = `address`.`countryId`)))
        LEFT JOIN `country_region` `cr` ON ((`cr`.`id` = `address`.`parentRegionId`)))
        LEFT JOIN `city` ON ((`city`.`id` = `address`.`cityId`)))
        LEFT JOIN `application_program` `T1` ON ((`T3`.`id` = `T1`.`applicationId`)))
        LEFT JOIN `users` `T50` ON ((`T50`.`id` = `T3`.`applicationApprovedBy`)))
        LEFT JOIN `applicant_bank_details` `T27` ON ((`T2`.`bankDetailId` = `T27`.`id`)))
        LEFT JOIN `applicant_hostel_requirement` `T52` ON (((`T52`.`applicantPersonId` = `T2`.`id`)
            AND (`T52`.`whetherDeleted` = 0))))
        LEFT JOIN `nationalities` `T49` ON ((`T2`.`nationalityId` = `T49`.`id`)))
        LEFT JOIN `caste_categories` `T46` ON ((`T2`.`casteCategoryId` = `T46`.`id`)))
        LEFT JOIN `applicant_person_relationships` `T42` ON (((`T42`.`applicantPersonId` = `T2`.`id`)
            AND (`T42`.`relationship` = 'FATHER')
            AND (`T42`.`whetherDeleted` = 0))))
        LEFT JOIN `religions` `T45` ON ((`T2`.`religionId` = `T45`.`id`)))
        LEFT JOIN `applicant_person_relationships` `T47` ON (((`T47`.`applicantPersonId` = `T2`.`id`)
            AND (`T47`.`relationship` = 'MOTHER')
            AND (`T47`.`whetherDeleted` = 0))))
        LEFT JOIN `application_admission_detail` `T18` ON ((`T18`.`applicationProgramId` = `T1`.`id`)))
        LEFT JOIN `programs` `T5` ON ((`T5`.`id` = `T1`.`programId`)))
        LEFT JOIN `program_group` `PG` ON ((`T5`.`programGroupId` = `PG`.`id`)))
        LEFT JOIN `academy_location` `T4` ON ((`T4`.`id` = `T1`.`academyLocationId`)))
        LEFT JOIN `prog_batch_seat_config` `T7` ON ((`T7`.`id` = `T1`.`progBatchSeatConfigId`)))
        LEFT JOIN `program_slctn_process_stages` `T10` ON ((`T10`.`id` = `T1`.`currentStageId`)))
        LEFT JOIN `application_prog_withdraw_reasons` `T51` ON ((`T51`.`id` = `T1`.`withdrawl_reason_id`)))
        LEFT JOIN `applicant_person` `T43` ON (((`T43`.`id` = `T42`.`relatedApplicantPersonId`)
            AND (`T42`.`relationship` = 'FATHER')
            AND (`T42`.`whetherDeleted` = 0))))
        LEFT JOIN `applicant_person` `T48` ON (((`T48`.`id` = `T47`.`relatedApplicantPersonId`)
            AND (`T47`.`relationship` = 'MOTHER')
            AND (`T47`.`whetherDeleted` = 0))))
        LEFT JOIN `admission` `T14` ON ((`T14`.`applicationAdmissionId` = `T18`.`id`)))
        LEFT JOIN `locations` `T19` ON ((`T19`.`id` = `T4`.`locationId`)))
        LEFT JOIN `academies` `T20` ON ((`T20`.`id` = `T4`.`academyId`)))
        LEFT JOIN `seat_types` `T8` ON ((`T8`.`id` = `T7`.`seatTypeId`)))
        LEFT JOIN `batches` `T15` ON ((`T15`.`id` = `T7`.`programBatchId`)))
        LEFT JOIN `intake_year` `t89` ON ((`t89`.`id` = `T15`.`intakeYearId`)))
        LEFT JOIN `application_prog_stage` `T9` ON (((`T9`.`applicationProgramId` = `T1`.`id`)
            AND (`T9`.`programSelectionProcessStageId` = `T10`.`id`))))
        LEFT JOIN `slctn_process_stage` `T11` ON ((`T11`.`id` = `T10`.`selectionProcessStageId`)))
        LEFT JOIN `bill_header` `T44` ON ((`T44`.`applicationProgramStageId` = `T9`.`id`)))
        LEFT JOIN `selection_stage` `T12` ON ((`T12`.`id` = `T11`.`stageId`)))
    WHERE
        ((`T3`.`applicationCreationSource` IS NOT NULL)
            AND (`T3`.`currentStatus` <> 'SOLD')
            AND (`T3`.`currentStatus` NOT IN ('DIRECT_SUBMISSION_TOKEN_GENERATED' , 'FORM_SALE_TOKEN_GENERATED'))
            AND (`T3`.`code` IS NOT NULL))
    ORDER BY `T3`.`applicationCreatedOn` DESC