DELIMITER $$

DROP PROCEDURE IF EXISTS V202001021914_Insert_UITranslation_Nationality $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V202001021914_Insert_UITranslation_Nationality()

BEGIN
  
  -- Insert new record in ui_translation table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName="TRANSLATIONS" and keyName="NATIONALITY" )) THEN
    
	-- Insert Query 
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('TRANSLATIONS','NATIONALITY','Nationality','Nationality',now(),1);

  END IF;

END $$

-- Execute the stored procedure
CALL V202001021914_Insert_UITranslation_Nationality() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V202001021914_Insert_UITranslation_Nationality $$
 
DELIMITER ;