CREATE OR REPLACE VIEW `pnc_dashboard_delayed_course_pbs` AS 
(SELECT 
        `ccp`.`academyLocationId` AS `academyLocationId`,
        `b`.`programId` AS `programId`,
        `ccp`.`programBatchId` AS `programBatchId`,
        `ccp`.`periodId` AS `periodId`,
        `ccp`.`courseId` AS `courseId`,
        `ccp`.`sectionId` AS `sectionId`,
        CONCAT(`al`.`academyName`,
                ' - ',
                `al`.`locationName`) AS `AcademyLocation`,
        `p`.`programNameToBePrint` AS `ProgramName`,
        `b`.`batchName` AS `BatchName`,
        `pbpc`.`programPeriodName` AS `PeriodName`,
        `c`.`courseName` AS `CourseName`,
        `cv`.`courseVariantCode` AS `CourseVariantCode`,
        `u`.`id` AS `facultyId`,
        `u`.`printName` AS `facultyName`,
        COUNT(0) AS `TotalSessions`,
        COUNT((CASE
            WHEN (`ccp`.`sessionDate` <= SYSDATE()) THEN `ccp`.`id`
        END)) AS `SessionTillDate`,
        COUNT((CASE
            WHEN
                ((`ccp`.`sessionDate` <= SYSDATE())
                    AND (`ccp`.`studentCourseAttendanceId` IS NOT NULL))
            THEN
                `ccp`.`id`
        END)) AS `SesssionConductedTillDate`,
        COUNT((CASE
            WHEN
                ((`ccp`.`sessionDate` <= SYSDATE())
                    AND ISNULL(`ccp`.`studentCourseAttendanceId`))
            THEN
                `ccp`.`id`
        END)) AS `DueTillDate`,
        ROUND(((COUNT((CASE
                    WHEN
                        ((`ccp`.`sessionDate` <= SYSDATE())
                            AND ISNULL(`ccp`.`studentCourseAttendanceId`))
                    THEN
                        `ccp`.`id`
                END)) / COUNT((CASE
                    WHEN (`ccp`.`sessionDate` <= SYSDATE()) THEN `ccp`.`id`
                END))) * 100),
                2) AS `Deviation`
    FROM
        (((((((`course_coverage_plan` `ccp`
        LEFT JOIN `academy_location` `al` ON ((`ccp`.`academyLocationId` = `al`.`id`)))
        LEFT JOIN `batches` `b` ON ((`ccp`.`programBatchId` = `b`.`id`)))
        LEFT JOIN `programs` `p` ON ((`b`.`programId` = `p`.`id`)))
        LEFT JOIN `prog_batch_period_config` `pbpc` ON ((`ccp`.`periodId` = `pbpc`.`id`)))
        LEFT JOIN `courses` `c` ON ((`ccp`.`courseId` = `c`.`id`)))
        LEFT JOIN `course_variants` `cv` ON ((`ccp`.`courseVariantId` = `cv`.`id`)))
        LEFT JOIN `users` `u` ON ((`ccp`.`facultyId` = `u`.`id`)))
    WHERE
        (`c`.`assignSectionType` = 'ProgramBatchSection') and `ccp`.`whetherDeleted`=false
    GROUP BY `ccp`.`courseVariantId`);
    
    
CREATE OR REPLACE VIEW `pnc_dashboard_delayed_course_cbs` AS
    (SELECT 
        `ccp`.`academyLocationId` AS `academyLocationId`,
        `pbpc`.`academicTermId` AS `academicTermId`,
        `ccp`.`courseId` AS `courseId`,
        `ccp`.`sectionId` AS `sectionId`,
        CONCAT(`al`.`academyName`,
                ' - ',
                `al`.`locationName`) AS `AcademyLocation`,
        `c`.`courseName` AS `CourseName`,
        `cv`.`id` AS `CourseVariantId`,
        `cv`.`courseVariantCode` AS `CourseVariantCode`,
        `u`.`id` AS `facultyId`,
        `u`.`printName` AS `facultyName`,
        COUNT(0) AS `TotalSessions`,
        COUNT((CASE
            WHEN (`ccp`.`sessionDate` <= SYSDATE()) THEN `ccp`.`id`
        END)) AS `SessionTillDate`,
        COUNT((CASE
            WHEN
                ((`ccp`.`sessionDate` <= SYSDATE())
                    AND (`ccp`.`studentCourseAttendanceId` IS NOT NULL))
            THEN
                `ccp`.`id`
        END)) AS `SesssionConductedTillDate`,
        COUNT((CASE
            WHEN
                ((`ccp`.`sessionDate` <= SYSDATE())
                    AND ISNULL(`ccp`.`studentCourseAttendanceId`))
            THEN
                `ccp`.`id`
        END)) AS `DueTillDate`,
        ROUND(((COUNT((CASE
                    WHEN
                        ((`ccp`.`sessionDate` <= SYSDATE())
                            AND ISNULL(`ccp`.`studentCourseAttendanceId`))
                    THEN
                        `ccp`.`id`
                END)) / COUNT((CASE
                    WHEN (`ccp`.`sessionDate` <= SYSDATE()) THEN `ccp`.`id`
                END))) * 100),
                2) AS `Deviation`
    FROM
        ((((((`course_coverage_plan` `ccp`
        LEFT JOIN `academy_location` `al` ON ((`ccp`.`academyLocationId` = `al`.`id`)))
        LEFT JOIN `courses` `c` ON ((`ccp`.`courseId` = `c`.`id`)))
        LEFT JOIN `course_variants` `cv` ON ((`ccp`.`courseVariantId` = `cv`.`id`)))
        LEFT JOIN `users` `u` ON ((`ccp`.`facultyId` = `u`.`id`)))
        LEFT JOIN `program_batch_course_param` `pbcp` ON ((`cv`.`id` = `pbcp`.`courseVarientId`)))
        LEFT JOIN `prog_batch_period_config` `pbpc` ON ((`pbcp`.`progBatchPeriodConfigId` = `pbpc`.`id`)))
    WHERE
        (`c`.`assignSectionType` = 'CourseSection') and `ccp`.`whetherDeleted`=false
    GROUP BY `ccp`.`courseVariantId`);
