DELIMITER $$

DROP PROCEDURE IF EXISTS V202001081749__InsertDFRFordDegreeClassificationAndRemark $$

CREATE PROCEDURE V202001081749__InsertDFRFordDegreeClassificationAndRemark()

BEGIN
	
	IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName='degreeclassificationform' and formFieldId='markingType' )) THEN
		INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
		VALUES ('degreeclassificationform','markingType','markingType','customcombobox',1,0,NULL,1,now(),'Program Marking Type',NULL,'DegreeClassification','Edit and View','Program Marking Type',0);
 	END IF;
 	
 	IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName='degreeclassificationform' and formFieldId='classificationName' )) THEN
		INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
		VALUES ('degreeclassificationform','classificationName','classificationName','textfield',1,0,NULL,1,now(),'Degree Classification Name',NULL,'DegreeClassification','Edit and View','Degree Classification Name',0);
	END IF;
 	
	IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName='degreeclassificationform' and formFieldId='degreeClassificationTypeRadio' )) THEN
		INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
		VALUES ('degreeclassificationform','degreeClassificationTypeRadio','degreeClassificationTypeRadio','radiogroup',0,0,'DEGREE_CERTIFICATE',1,now(),'Degree Classification For',NULL,'DegreeClassification','Edit and View','Degree Classification For',0);
	END IF;
	
	
 	IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName='degreeremarkform' and formFieldId='classificationName' )) THEN
		INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
		VALUES ('degreeremarkform','classificationName','classificationName','textfield',0,0,NULL,1,now(),'Degree Classification Name',NULL,'DegreeRemark','Edit and View','Degree Classification Name',0);
	END IF;
 	
	IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName='degreeremarkform' and formFieldId='markingType' )) THEN
		INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
		VALUES ('degreeremarkform','markingType','markingType','customcombobox',1,0,NULL,1,now(),'Program Marking Type',NULL,'DegreeRemark','Edit and View','Program Marking Type',0);
	END IF;
 	
	IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName='degreeremarkform' and formFieldId='rangeFrom' )) THEN
		INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
		VALUES ('degreeremarkform','rangeFrom','rangeFrom','numberfield',1,0,NULL,1,now(),'CGPA Range From',NULL,'DegreeRemark','Edit and View','CGPA Range From',0);
	END IF;
 	IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName='degreeremarkform' and formFieldId='rangeTo' )) THEN
		INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
		VALUES ('degreeremarkform','rangeTo','rangeTo','numberfield',1,0,NULL,1,now(),'CGPA Range To',NULL,'DegreeRemark','Edit and View','CGPA Range To',0);
	END IF;
 	IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName='degreeremarkform' and formFieldId='remark' )) THEN
		INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
		VALUES ('degreeremarkform','remark','remark','textfield',1,0,NULL,1,now(),'Remark',NULL,'DegreeRemark','Edit and View','Remark',0);
	END IF;
 	IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName='degreeremarkform' and formFieldId='recommendation' )) THEN
		INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
		VALUES ('degreeremarkform','recommendation','recommendation','textfield',0,0,NULL,1,now(),'Recommendation/Decision',NULL,'DegreeRemark','Edit and View','Recommendation/Decision',0);
	END IF;
 	IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName='degreeremarkform' and formFieldId='graphColor' )) THEN
		INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
		VALUES ('degreeremarkform','graphColor','graphColor','textfield',0,0,NULL,1,now(),'Graph Color',NULL,'DegreeRemark','Edit and View','Graph Color',0);
	END IF;

END $$

CALL V202001081749__InsertDFRFordDegreeClassificationAndRemark() $$

DROP PROCEDURE IF EXISTS V202001081749__InsertDFRFordDegreeClassificationAndRemark $$
 
DELIMITER ;
