DELIMITER $$

DROP PROCEDURE IF EXISTS application_followup_insert $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE application_followup_insert()

BEGIN
  
INSERT INTO application_followup(
    userId, applicationId, assignTo, followUpNo, followUpDate, 
    whetherDeleted, lastUpdatedBy, lastUpdate, isLatestFollowUp, enqPriorityId, status
) select applicationOwner,id,applicationOwner,0,now(), false,1,now(),true,@enqPriorityId,'Open' from application where currentStatus != 'ADMISSION_GRANTED' and applicationOwner is not null;

INSERT INTO application_followup(
    userId, applicationId, assignTo, followUpNo, followUpDate, 
    whetherDeleted, lastUpdatedBy, lastUpdate, isLatestFollowUp, enqPriorityId, status
) select 1,id,1 ,0,now(), false,1,now(),true,@enqPriorityId,'Open' from application where currentStatus != 'ADMISSION_GRANTED' and applicationOwner is null and applicationOwner is null;

INSERT INTO application_followup(
    userId, applicationId, assignTo, followUpNo, followUpDate, actualFollowUpDate, 
    whetherDeleted, lastUpdatedBy, lastUpdate, isLatestFollowUp, enqPriorityId, status
) select applicationOwner,id,applicationOwner,0,now(),now(), false,1,now(),true,@enqPriorityId,'Closed' from application where currentStatus = 'ADMISSION_GRANTED' and applicationOwner is not null;

INSERT INTO application_followup(
    userId, applicationId, assignTo, followUpNo, followUpDate, actualFollowUpDate, 
    whetherDeleted, lastUpdatedBy, lastUpdate, isLatestFollowUp, enqPriorityId, status
) select 1,id,1,0,now(),now(), false,1,now(),true,@enqPriorityId,'Closed' from application where currentStatus = 'ADMISSION_GRANTED' and applicationOwner is null;

END $$

-- Execute the stored procedure
CALL application_followup_insert() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS application_followup_insert $$
 
DELIMITER ;