DELIMITER $$

DROP PROCEDURE IF EXISTS RegionCode $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE RegionCode()

BEGIN
  
  -- Add the column to the table, if it doesn't already exist
  IF EXISTS ((SELECT * FROM information_schema.COLUMNS WHERE table_schema=DATABASE() AND table_name='currency' 
  AND column_name='regionCode')) THEN
  
 ALTER TABLE `currency` CHANGE COLUMN `regionCode` `regionCode` VARCHAR(10) NULL DEFAULT NULL;
  
  END IF;

END $$

-- Execute the stored procedure
CALL RegionCode() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS RegionCode $$
 
DELIMITER ;