DELIMITER $$

DROP PROCEDURE IF EXISTS V202001101904__Insert_AddReportTemplate $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V202001101904__Insert_AddReportTemplate()

BEGIN
  
  IF NOT EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'AU_DEGREE_AUDIT_REPORT' )) THEN
    
	INSERT INTO report_template (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES ('10', 'AU_DEGREE_AUDIT_REPORT', 'Degree Audit Report', 'AU_DEGREE_AUDIT_REPORT.png', 'CommonReport_AuditDegreeReport.jasper', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'AU_DEGREE_AUDIT_REPORT.jasper', 'AcademiaLogo.png');

  END IF;
  
  IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE reportTemplateId = (select id from report_template where templateCode ='AU_DEGREE_AUDIT_REPORT') )) THEN
  
  set @degreeAuditReportID = (select id from report_template where templateCode ='AU_DEGREE_AUDIT_REPORT');
	
  INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`) 
		VALUES 	(@degreeAuditReportID, 'TRANS_NAME', 'Name:', '1',now()),
				(@degreeAuditReportID, 'TRANS_SEX', 'Sex:', '1', now()),
				(@degreeAuditReportID, 'TRANS_REG_NUMBER', 'Registeration Number:', '1', now()),
				(@degreeAuditReportID, 'TRANS_PROGRAM', 'Program:', '1', now()),
				(@degreeAuditReportID, 'TRANS_INTAKE', 'Intake:', '1', now()),
				(@degreeAuditReportID, 'TRANS_DURATION', 'Duration:', '1', now()),
				(@degreeAuditReportID, 'TRANS_CURRENT_SEMESTER', 'Current Semester:', '1', now()),
				(@degreeAuditReportID, 'TRANS_CURRENT_CGPA', 'Current CGPA:', '1', now()),
				(@degreeAuditReportID, 'TRANS_MINIMUM_COURSES', 'Minimum Courses Required:', '1', now()),
				(@degreeAuditReportID, 'TRANS_MINIMUM_CREDITS', 'Minimum Credits Required:', '1', now()),
				(@degreeAuditReportID, 'TRANS_OVERALL_STATUS', 'Overall Status:', '1', now()),
				(@degreeAuditReportID, 'TRANS_TITLE', 'Degree Audit Report', '1', now()),
				(@degreeAuditReportID, 'TRANS_COURSES_NAME', 'Course Name', '1', now()),
				(@degreeAuditReportID, 'TRANS_COURSES_TYPE', 'Course Type', '1', now()),
				(@degreeAuditReportID, 'TRANS_OBTAINED_MARKS', 'Obtained Marks/Grade', '1', now()),
				(@degreeAuditReportID, 'TRANS_OBTAINED_CREDIT', 'Obtained Credit', '1', now()),
				(@degreeAuditReportID, 'TRANS_RESULT_STATUS', 'Result Status', '1', now()),
				(@degreeAuditReportID, 'TRANS_ACADEMIC_TERM', 'Academic Term', '1', now()),
				(@degreeAuditReportID, 'TRANS_NUMBER_OF_ATTEMPTS', 'Number of attempts', '1', now()),
				(@degreeAuditReportID, 'TRANS_OUTSTANDING_COURSES', 'Outstanding courses:', '1', now()),
				(@degreeAuditReportID, 'TRANS_OUTSTANDING_CREDITS', 'Outstanding credits:', '1', now()),
				(@degreeAuditReportID, 'TRANS_OVERALL_PERCENTAGE', 'Overall Percantage of completion:', '1', now()),
				(@degreeAuditReportID, 'TRANS_RECOMMENDATION', 'Recommendation/Decision:', '1', now());

  END IF;
   
END $$

-- Execute the stored procedure
CALL V202001101904__Insert_AddReportTemplate() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V202001101904__Insert_AddReportTemplate $$
 
DELIMITER ;


