DROP procedure IF EXISTS `updateCalculationStudentCourseEnrollment`;

DELIMITER $$

CREATE PROCEDURE `updateCalculationStudentCourseEnrollment`(
IN admissionId BIGINT(20),
IN periodId BIGINT(20),
IN courseVariantId BIGINT(20),
IN sectionId BIGINT(20),
IN whetherPassed BIT(1),
IN whetherFailed BIT(1),
IN obtainedMarks varchar(45),
IN parentCourseObtainedMarkGrade varchar(45),
IN whetherPassedInParentCourse BIT(1)
)
BEGIN
START TRANSACTION;

 BLOCK1: begin
set sql_safe_updates=0;
if(obtainedMarks is not null) then
	UPDATE student_course_enrollment as er SET er.whetherFailed = whetherFailed,er.whetherPassed = whetherPassed, 
		er.marksObtained = obtainedMarks WHERE er.admissionId = admissionId and er.courseVarientId = courseVariantId 
		and er.sectionId = sectionId and er.programBatchPeriodConfigId = periodId;
else 
	UPDATE student_course_enrollment as er SET er.whetherPassedInParentCourse = whetherPassedInParentCourse,
		er.parentCourseObtainedMarkGrade = parentCourseObtainedMarkGrade WHERE er.admissionId = admissionId and 
		er.courseVarientId = courseVariantId and er.sectionId = sectionId and er.programBatchPeriodConfigId = 
        periodId;
set sql_safe_updates=1;
end if;
END BLOCK1;

COMMIT;    

END$$

DELIMITER ;
