DELIMITER $$

DROP PROCEDURE IF EXISTS V202001141731__Insert_AdmissionActivityRadioGroupPrivilege $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V202001141731__Insert_AdmissionActivityRadioGroupPrivilege()

BEGIN
  
  -- Insert new record in privilege table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM privilege WHERE code="USER_ACTIVITY_REPORT" and id="411" )) THEN
	-- Insert Query 
	INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) 
VALUES ('411', '0', 'User Activity Report', 'User Activity Report', 'USER_ACTIVITY_REPORT', 'User Activity Report', '1', now());
  END IF;
  
   IF NOT EXISTS ((SELECT * FROM privilege WHERE code="SALE_ADMISSION_ENROLMENT_SUMMARY_REPORT" and id="412" )) THEN
	-- Insert Query 
	INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) 
VALUES ('412', '0', 'Sales and Admission Enrolment Summary Report', 'Sales and Admission Enrolment Summary Report', 'SALE_ADMISSION_ENROLMENT_SUMMARY_REPORT', 'Sales and Admission Enrolment Summary Report', '1', now());
  END IF;

END $$

-- Execute the stored procedure
CALL V202001141731__Insert_AdmissionActivityRadioGroupPrivilege() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V202001141731__Insert_AdmissionActivityRadioGroupPrivilege $$
 
DELIMITER ;