-- enquirymulprogramform

DELIMITER $$

DROP PROCEDURE IF EXISTS update_enquiry_student_dfr_edit_view $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE update_enquiry_student_dfr_edit_view()

BEGIN

  IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE `formAliasName`='studentdetailform' and `formFieldName`='emailId' and `formFieldId`='stdEmailId' and `formFieldInputType`='textfield' )) THEN
    
    INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`) VALUES 
('studentdetailform','emailId','stdEmailId','textfield',0,0,NULL,1,'2020-01-14 18:26:00','Email Address','1','Student Enquiry Details','Edit and View','Email Address',0);

  END IF;
  
  -- Insert new record in email table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE `formAliasName`='studentdetailform' and `formFieldId`='mobileNoFldItemId' and `formFieldInputType`='fieldcontainer' )) THEN
    
	INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`) VALUES 
('studentdetailform',null,'mobileNoFldItemId','fieldcontainer',0,0,NULL,1,'2020-01-14 18:26:00','Mobile No.','1','Student Enquiry Details','Edit and View','Mobile No.',0);

  END IF;
  
  IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE `formAliasName`='studentdetailform' and `formFieldName`='mobileCountryCode' and `formFieldId`='stdCountryCodeItemId' and `formFieldInputType`='customcombobox' )) THEN
    
    INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`) VALUES 
('studentdetailform','mobileCountryCode','stdCountryCodeItemId','customcombobox',0,0,NULL,1,'2020-01-14 18:26:00','Mobile No.','1','Student Enquiry Details','Edit and View','Country Code.',0);

  END IF;
  
  IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE `formAliasName`='studentdetailform' and `formFieldName`='mobileNumber' and `formFieldId`='stdMobileNumberItemId' and `formFieldInputType`='numberfield' )) THEN
    
    INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`) VALUES 
('studentdetailform','mobileNumber','stdMobileNumberItemId','numberfield',0,0,NULL,1,'2020-01-14 18:26:00','','1','Student Enquiry Details','Edit and View','Mobile No.',0);

  END IF;
  
  IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE `formAliasName`='studentdetailform' and `formFieldName`='alternateMobileCountryCode' and `formFieldId`='stdAlternateMobileCountryCode' and `formFieldInputType`='customcombobox' )) THEN
    
    INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`) VALUES 
('studentdetailform','alternateMobileCountryCode','stdAlternateMobileCountryCode','customcombobox',0,0,NULL,1,'2020-01-14 18:26:00','Alternate Mobile No.','1','Student Enquiry Details','Edit and View','Alternate Country Code.',0);

  END IF;
  
  IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE `formAliasName`='studentdetailform' and `formFieldName`='alternateMobileNo' and `formFieldId`='stdAlternateMobileNo' and `formFieldInputType`='numberfield' )) THEN
    
    INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`) VALUES 
('studentdetailform','alternateMobileNo','stdAlternateMobileNo','numberfield',0,0,NULL,1,'2020-01-14 18:26:00','','1','Student Enquiry Details','Edit and View','Alternate Mobile No.',0);

  END IF;
  
  IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE `formAliasName`='studentdetailform' and `formFieldId`='alternateMobileNoFldItemId' and `formFieldInputType`='fieldcontainer' )) THEN
    
    INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`) VALUES 
('studentdetailform',null,'alternateMobileNoFldItemId','fieldcontainer',0,0,NULL,1,'2020-01-14 18:26:00','Alternate Mobile No.','1','Student Enquiry Details','Edit and View','Alternate Mobile No.',0);

  END IF;      

END $$

-- Execute the stored procedure
CALL update_enquiry_student_dfr_edit_view() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS update_enquiry_student_dfr_edit_view $$
 
DELIMITER ;