DELIMITER $$

DROP PROCEDURE IF EXISTS V202001171348__UITranslation_RestrictIPs $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V202001171348__UITranslation_RestrictIPs()

BEGIN
 
  -- Insert new record in ui_translation table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'TRANSLATIONS' and keyName = 'RESTRICTED_IPS' )) THEN
   
	INSERT INTO `ui_translation`(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`)
    VALUES ('TRANSLATIONS','RESTRICTED_IPS','Enter IPs to allow login (comma separated)','Enter IPs to allow login (comma separated)',now(),1);
   
  END IF;
  
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'TRANSLATIONS' and keyName = 'NOT_ABLE_TO_LOGIN_DUE_TO_RESTRICTED_IP_ADDRESS' )) THEN

	INSERT INTO `ui_translation`(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`)
    VALUES ('TRANSLATIONS','NOT_ABLE_TO_LOGIN_DUE_TO_RESTRICTED_IP_ADDRESS','You cannot login from this machine or location due to IP address restrictions on your account.','You cannot login from this machine or location due to IP address restrictions on your account.',now(),1);
   
  END IF;

END $$


-- Execute the stored procedure
CALL V202001171348__UITranslation_RestrictIPs() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V202001171348__UITranslation_RestrictIPs $$
 
DELIMITER ;