DELIMITER $$
DROP PROCEDURE IF EXISTS V202001201623__AlterBillHeaderTableacadLocCurrencyConvertionId $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V202001201623__AlterBillHeaderTableacadLocCurrencyConvertionId()

BEGIN
  
  -- Add the email_address column to the email table, if it doesn't already exist
  
 IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='bill_header' 
  AND column_name='orgCurrConvertedAmount')) THEN
  ALTER TABLE `bill_header`
	ADD COLUMN `orgCurrConvertedAmount` DOUBLE(20,2) NULL DEFAULT NULL AFTER `acadLocCurrConvertedAmount`,
	ADD INDEX `fk_bill_header_academyLocationCurrency_idx` (`acadLocCurrencyConvertionId` ASC),
	ADD INDEX `fk_bill_header_organizationCurrency_idx` (`orgCurrencyConvertionId` ASC);
	ALTER TABLE `bill_header` 
	ADD CONSTRAINT `fk_bill_header_academyLocationCurrency`
  		FOREIGN KEY (`acadLocCurrencyConvertionId`)
  		REFERENCES `currency_exchange_history` (`id`)
  		ON DELETE RESTRICT
  		ON UPDATE RESTRICT,
	ADD CONSTRAINT `fk_bill_header_organizationCurrency`
  		FOREIGN KEY (`orgCurrencyConvertionId`)
  		REFERENCES `currency_exchange_history` (`id`)
  		ON DELETE RESTRICT
  		ON UPDATE RESTRICT;
  END IF;

END $$

-- Execute the stored procedure
CALL V202001201623__AlterBillHeaderTableacadLocCurrencyConvertionId() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V202001201623__AlterBillHeaderTableacadLocCurrencyConvertionId $$
 
DELIMITER ;