DELIMITER $$

DROP PROCEDURE IF EXISTS InsertUITranslationIsExistGroupAssignment $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE InsertUITranslationIsExistGroupAssignment()

BEGIN
  
  -- Insert new record in ui_translation table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'PROGRAMANDCOURSE' and keyName = 'HOMEWORK_ASSIGNMENT_GROUP_EXIST' )) THEN
    
	INSERT INTO `ui_translation`(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
    VALUES ('PROGRAMANDCOURSE','HOMEWORK_ASSIGNMENT_GROUP_EXIST','cannot be added as some students of the group are already added to the assignment.','cannot be added as some students of the group are already added to the assignment.',now(),1);
   
  END IF;
  
END $$

-- Execute the stored procedure
CALL InsertUITranslationIsExistGroupAssignment() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS InsertUITranslationIsExistGroupAssignment $$
 
DELIMITER ;