DELIMITER $$
DROP PROCEDURE IF EXISTS V202001281352__CreateInsertCecosStudentIdCardReportTemplate $$
CREATE PROCEDURE V202001281352__CreateInsertCecosStudentIdCardReportTemplate()
BEGIN
IF NOT EXISTS ((SELECT * FROM `report_template` WHERE `templateCode` = 'CECOS_STUDENT_ID_CARD')) THEN 
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`)
VALUES ('7', 'CECOS_STUDENT_ID_CARD', 'CECOS Student ID Card', 'CECOS_Student_ID_Card.png', 'CommonReport_IdCard_Horizontal_ATMCardSize.jasper', 'All', '1', 'FooterBlank_IdCard.jasper', 'FooterBlank_IdCard.jasper', '1', '1', 'studentIDCard_CECOS.jasper', 'AcademiaLogo.png');
END IF;

set @CECOS_Student_ID_Card = (select max(id) from report_template where templateCode ='CECOS_STUDENT_ID_CARD');

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE reportTemplateId=@CECOS_Student_ID_Card and `keyValue` = 'TRANS_COLLEGE_ID')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@CECOS_Student_ID_Card, 'TRANS_COLLEGE_ID', 'College ID:', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE reportTemplateId=@CECOS_Student_ID_Card and `keyValue` = 'TRANS_COURSE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@CECOS_Student_ID_Card, 'TRANS_COURSE', 'Course:', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE reportTemplateId=@CECOS_Student_ID_Card and `keyValue` = 'TRANS_END_DATE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@CECOS_Student_ID_Card, 'TRANS_END_DATE', 'End Date:', '1', NOW());
END IF;

END $$
CALL V202001281352__CreateInsertCecosStudentIdCardReportTemplate $$ 
DROP PROCEDURE IF EXISTS V202001281352__CreateInsertCecosStudentIdCardReportTemplate $$ 
DELIMITER ;