DELIMITER $$

DROP PROCEDURE IF EXISTS V202001291902__AlterReceiptPaymentInstrument $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V202001291902__AlterReceiptPaymentInstrument()

BEGIN
  
  -- Add the column to the table, if it doesn't already exist
  IF EXISTS ((SELECT * FROM information_schema.COLUMNS WHERE table_schema=DATABASE() AND table_name='receipt_payment_instrument')) THEN
	ALTER TABLE `receipt_payment_instrument` 
		ADD COLUMN `acadLocCurrencyConversionId` BIGINT(20) NULL DEFAULT NULL AFTER `lastUpdate`,
		ADD COLUMN `orgCurrencyConversionId` BIGINT(20) NULL DEFAULT NULL AFTER `acadLocCurrencyConversionId`,
		ADD COLUMN `acadLocCurrConvertedAmount` DOUBLE(20,2) NULL DEFAULT NULL AFTER `orgCurrencyConversionId`,
		ADD COLUMN `orgCurrConvertedAmount` DOUBLE(20,2) NULL DEFAULT NULL AFTER `acadLocCurrConvertedAmount`,
		ADD COLUMN `receiptPayInstrumentCurrencyId` BIGINT(20) NULL DEFAULT NULL AFTER `orgCurrConvertedAmount`,
		ADD COLUMN `orgCurrencyId` BIGINT(20) NULL DEFAULT NULL AFTER `receiptPayInstrumentCurrencyId`,
		ADD INDEX `fk_receipt_payment_instrument_academyLocationCurrency_idx` (`acadLocCurrencyConversionId` ASC),
		ADD INDEX `fk_receipt_payment_instrument_payinstrument_currency_to_cur_idx` (`receiptPayInstrumentCurrencyId` ASC),
		ADD INDEX `fk_receipt_payment_instrument_organizationCurrency_idx` (`orgCurrencyConversionId` ASC),
		ADD INDEX `fk_receipt_payment_instrument_org_currency_to_currency_idx` (`orgCurrencyId` ASC);

		ALTER TABLE `receipt_payment_instrument` 
		ADD CONSTRAINT `fk_receipt_payment_instrument_academyLocationCurrency`
		  FOREIGN KEY (`acadLocCurrencyConversionId`)
		  REFERENCES `currency_exchange_history` (`id`)
		  ON DELETE RESTRICT
		  ON UPDATE RESTRICT,
		ADD CONSTRAINT `fk_receipt_payment_instrument_org_currency_to_currency`
		  FOREIGN KEY (`orgCurrencyId`)
		  REFERENCES `currency` (`id`)
		  ON DELETE RESTRICT
		  ON UPDATE RESTRICT,
		ADD CONSTRAINT `fk_receipt_payment_instrument_organizationCurrency`
		  FOREIGN KEY (`orgCurrencyConversionId`)
		  REFERENCES `currency_exchange_history` (`id`)
		  ON DELETE RESTRICT
		  ON UPDATE RESTRICT,
		ADD CONSTRAINT `fk_receipt_payment_instrument_payinstrument_currency_to_currency`
		  FOREIGN KEY (`receiptPayInstrumentCurrencyId`)
		  REFERENCES `currency` (`id`)
		  ON DELETE RESTRICT
		  ON UPDATE RESTRICT;
  
  END IF;

END $$

-- Execute the stored procedure
CALL V202001291902__AlterReceiptPaymentInstrument() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V202001291902__AlterReceiptPaymentInstrument $$
 
DELIMITER ;