DELIMITER $$
DROP PROCEDURE IF EXISTS V20200224172302__Create_createProgramOutComesTable $$
CREATE PROCEDURE V20200224172302__Create_createProgramOutComesTable()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='manage_program_outcomes')) THEN 
CREATE TABLE `manage_program_outcomes` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `batchId` bigint(20) NOT NULL,
  `outcomesType` bigint(20) NOT NULL,
  `programOutComeCode` varchar(255) NOT NULL,
  `description` varchar(550) DEFAULT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique` (`batchId`,`programOutComeCode`),
  KEY `fk_manage_program_outcomes_Batch_idx` (`batchId`),
  KEY `fk_manage_program_outcomes_programOutComes_idx` (`outcomesType`),
  KEY `fk_manage_program_outcomes_users_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_manage_program_outcomes_Batch` FOREIGN KEY (`batchId`) REFERENCES `batches` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_manage_program_outcomes_programOutComes` FOREIGN KEY (`outcomesType`) REFERENCES `program_out_comes_type` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_manage_program_outcomes_users` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8;


END IF; 

END $$
CALL V20200224172302__Create_createProgramOutComesTable () $$ 
DROP PROCEDURE IF EXISTS V20200224172302__Create_createProgramOutComesTable $$ 
DELIMITER ;