DELIMITER $$
DROP PROCEDURE IF EXISTS V20200224184433__Create_mapcourseoutAndprogramoutcomesTable $$
CREATE PROCEDURE V20200224184433__Create_mapcourseoutAndprogramoutcomesTable()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='map_course_outcomes_program_outcomes')) THEN 
CREATE TABLE `map_course_outcomes_program_outcomes` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `periodId` bigint(20) NOT NULL,
  `manageCourseOutComeId` bigint(20) NOT NULL,
  `manageProgramOutComeId` bigint(20) NOT NULL,
  `obeCorrelationId` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_map_course_outcomes_program_outcomes_users_idx` (`lastUpdatedBy`),
  KEY `fk_map_course_outcomes_program_outcomes_obe_outCome_idx` (`obeCorrelationId`),
  KEY `fk_map_course_outcomes_program_outcomes_course_outCome_idx` (`manageProgramOutComeId`),
  KEY `fk_map_course_outcomes_program_outcomes_period_idx` (`periodId`),
  KEY `fk_map_course_outcomes_program_outcomes_courseAndPorgramOut_idx` (`manageCourseOutComeId`),
  CONSTRAINT `fk_map_course_outcomes_program_outcomes_courseAndPorgramOutcomes` FOREIGN KEY (`manageCourseOutComeId`) REFERENCES `manage_course_outcomes` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_map_course_outcomes_program_outcomes_obe_outCome` FOREIGN KEY (`obeCorrelationId`) REFERENCES `obe_correlation_level` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_map_course_outcomes_program_outcomes_period` FOREIGN KEY (`periodId`) REFERENCES `prog_batch_period_config` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_map_course_outcomes_program_outcomes_program_outCome` FOREIGN KEY (`manageProgramOutComeId`) REFERENCES `manage_program_outcomes` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_map_course_outcomes_program_outcomes_users` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

END IF; 

END $$
CALL V20200224184433__Create_mapcourseoutAndprogramoutcomesTable () $$ 
DROP PROCEDURE IF EXISTS V20200224184433__Create_mapcourseoutAndprogramoutcomesTable $$ 
DELIMITER ;