DELIMITER $$
DROP PROCEDURE IF EXISTS V20200228175706__Alter_addColumnsInApplicantPerson $$
CREATE PROCEDURE V20200228175706__Alter_addColumnsInApplicantPerson()
BEGIN

IF NOT EXISTS ((select * from information_schema.COLUMNS where table_schema=DATABASE() and  table_name='applicant_person' AND
column_name in ('whether_company_sponsored','campaign_school_id','campaign_new_id','source_id'))) THEN 
Alter TABLE applicant_person
	ADD COLUMN `whether_company_sponsored` BIT(1) NULL DEFAULT NULL AFTER `genderId`,
	ADD COLUMN `campaign_school_id` BIGINT(20) NULL DEFAULT NULL AFTER `whether_company_sponsored`,
	ADD COLUMN `campaign_new_id` BIGINT(20) NULL DEFAULT NULL AFTER `campaign_school_id`,
	ADD COLUMN `source_id` BIGINT(20) NULL DEFAULT NULL AFTER `campaign_new_id`,
	ADD INDEX `fk_applicant_person_enquiry_source_idx` (`source_id` ASC),
	ADD INDEX `fk_applicant_person_campaign_school_idx` (`campaign_school_id` ASC),
	ADD INDEX `fk_applicant_person_campaign_new_idx` (`campaign_new_id` ASC);

	ALTER TABLE `applicant_person` 
	ADD CONSTRAINT `fk_applicant_person_enquiry_source`
	  FOREIGN KEY (`source_id`)
	  REFERENCES `enquiry_source` (`id`)
	  ON DELETE NO ACTION
	  ON UPDATE NO ACTION,
	ADD CONSTRAINT `fk_applicant_person_campaign_school`
	  FOREIGN KEY (`campaign_school_id`)
	  REFERENCES `campaign_school` (`id`)
	  ON DELETE NO ACTION
	  ON UPDATE NO ACTION,
	ADD CONSTRAINT `fk_applicant_person_campaign_new`
	  FOREIGN KEY (`campaign_new_id`)
	  REFERENCES `campaign_new` (`id`)
	  ON DELETE NO ACTION
	  ON UPDATE NO ACTION;
  
END IF; 

END $$
CALL V20200228175706__Alter_addColumnsInApplicantPerson() $$
DROP PROCEDURE IF EXISTS V20200228175706__Alter_addColumnsInApplicantPerson $$
DELIMITER ;
