DELIMITER $$

DROP PROCEDURE IF EXISTS V20200311113854__Create_ReviewParameterRating $$

CREATE PROCEDURE V20200311113854__Create_ReviewParameterRating()

BEGIN

	IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='review_parameter_rating')) THEN 

		CREATE TABLE `review_parameter_rating` (
  		`id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  		`reviewParameterId` BIGINT(20) NULL,
  		`itemCode` varchar(255) NOT NULL,
		`itemValue` varchar(255) NOT NULL,
		`lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
		`lastUpdatedBy` bigint(20) NOT NULL,
		PRIMARY KEY (`id`),
		INDEX `fk_review_parameter_rating_review_parameter_id_idx` (`reviewParameterId` ASC),
		INDEX `fk_review_parameter_rating_lastUpdatedBy_user_id_idx` (`lastUpdatedBy` ASC),
	  	CONSTRAINT `fk_review_parameter_rating_review_parameter_id_idx`
		    FOREIGN KEY (`reviewParameterId`)
		    REFERENCES `review_parameter` (`id`)
		    ON DELETE RESTRICT
		    ON UPDATE RESTRICT,
	  	CONSTRAINT `fk_review_parameter_rating_lastUpdatedBy_user_id_idx`
		    FOREIGN KEY (`lastUpdatedBy`)
		    REFERENCES `users` (`id`)
		    ON DELETE RESTRICT
		    ON UPDATE RESTRICT
		) ENGINE=InnoDB DEFAULT CHARSET=utf8;

	END IF; 
	
	IF NOT EXISTS ((SELECT * FROM standard_master WHERE tableName = 'review_parameter_rating')) THEN 

		SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
		INSERT INTO `standard_master`(`id`,`tableName`, `masterName`, `moduleName`, `filterCode`, `whetherChild`, `whetherParent`, `lastUpdatedBy`,`lastUpdate`) 
		VALUES (@standardMasterMaxId+1, 'review_parameter_rating','REVIEW_PARAMETER_RATING','Admissions','COMMON_MASTER',1,0,1,SYSDATE());
		
		SET FOREIGN_KEY_CHECKS=0;
		SET SQL_SAFE_UPDATES = 0;
		SET @standardMasterId=(SELECT id FROM standard_master WHERE `tableName`='review_parameter_rating');
		UPDATE `standard_master` SET `childMaster`=@standardMasterId, `whetherParent`=1 WHERE `tableName`='review_parameter';
		SET SQL_SAFE_UPDATES = 1;
		SET FOREIGN_KEY_CHECKS=1;
		
		SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
		INSERT INTO `standard_master_items`(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`,`lastUpdate`) 
		VALUES (@ItemsMaxId+1, 'code', 'RATING_CODE', @standardMasterMaxId+1, 'Varchar', '1', 0, 0, 0, 0, '1',SYSDATE());
		
		SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
		INSERT INTO `standard_master_items`(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`,`lastUpdate`) 
		VALUES (@ItemsMaxId+1, 'value', 'RATING_SCALE', @standardMasterMaxId+1, 'Varchar', '2', 0, 0, 0, 0, '1',SYSDATE());

	END IF; 

END $$

CALL V20200311113854__Create_ReviewParameterRating () $$

DROP PROCEDURE IF EXISTS V20200311113854__Create_ReviewParameterRating $$

DELIMITER ;